/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.adapter.AbstractUserAdapterFederatedStorage;
import org.keycloak.storage.federated.UserGroupMembershipFederatedStorage;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;
import org.keycloak.utils.StreamsUtil;

public class UserMapStorage
implements UserLookupProvider.Streams,
UserStorageProvider,
UserRegistrationProvider,
CredentialInputUpdater.Streams,
CredentialInputValidator,
UserGroupMembershipFederatedStorage.Streams,
UserQueryProvider.Streams,
ImportedUserValidation {
    private static final Logger log = Logger.getLogger(UserMapStorage.class);
    protected final Map<String, String> userPasswords;
    protected final ConcurrentMap<String, Set<String>> userGroups;
    protected ComponentModel model;
    protected KeycloakSession session;
    protected UserStorageProvider.EditMode editMode;
    private transient Boolean importEnabled;
    public static final AtomicInteger allocations = new AtomicInteger(0);
    public static final AtomicInteger closings = new AtomicInteger(0);
    public static final AtomicInteger realmRemovals = new AtomicInteger(0);
    public static final AtomicInteger groupRemovals = new AtomicInteger(0);
    public static final AtomicInteger roleRemovals = new AtomicInteger(0);

    public UserMapStorage(KeycloakSession session, ComponentModel model, Map<String, String> userPasswords, ConcurrentMap<String, Set<String>> userGroups) {
        this.session = session;
        this.model = model;
        this.userPasswords = userPasswords;
        this.userGroups = userGroups;
        allocations.incrementAndGet();
        String editModeString = (String)model.getConfig().getFirst((Object)"editMode");
        this.editMode = editModeString == null ? UserStorageProvider.EditMode.UNSYNCED : UserStorageProvider.EditMode.valueOf((String)editModeString);
    }

    private static String getUserIdInMap(RealmModel realm, String userId) {
        return realm.getId() + "/" + userId;
    }

    public UserModel getUserById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        String username = storageId.getExternalId();
        if (!this.userPasswords.containsKey(UserMapStorage.translateUserName(username))) {
            return null;
        }
        return this.createUser(realm, username);
    }

    public Set<String> getUsernames() {
        return this.userPasswords.keySet();
    }

    private UserModel createUser(RealmModel realm, final String username) {
        Object user;
        if (this.isImportEnabled()) {
            user = this.session.userLocalStorage().addUser(realm, username);
            user.setEnabled(true);
            user.setFederationLink(this.model.getId());
        } else {
            user = new AbstractUserAdapterFederatedStorage.Streams(this.session, realm, this.model){

                public String getUsername() {
                    return username.toLowerCase();
                }

                public void setUsername(String innerUsername) {
                    if (!Objects.equals(innerUsername, username.toLowerCase())) {
                        throw new RuntimeException("Unsupported");
                    }
                }

                public void leaveGroup(GroupModel group) {
                    UserMapStorage.this.leaveGroup(this.realm, this.getUsername(), group);
                }

                public void joinGroup(GroupModel group) {
                    UserMapStorage.this.joinGroup(this.realm, this.getUsername(), group);
                }

                public String getFederationLink() {
                    return UserMapStorage.this.model.getId();
                }
            };
        }
        return user;
    }

    public boolean supportsCredentialType(String credentialType) {
        return "password".equals(credentialType);
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password")) {
            this.userPasswords.put(UserMapStorage.translateUserName(user.getUsername()), input.getChallengeResponse());
            return true;
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        return Stream.empty();
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return "password".equals(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof PasswordUserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password")) {
            String pw = this.userPasswords.get(UserMapStorage.translateUserName(user.getUsername()));
            return pw != null && pw.equals(((UserCredentialModel)input).getValue());
        }
        return false;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        if (!this.userPasswords.containsKey(UserMapStorage.translateUserName(username))) {
            return null;
        }
        return this.createUser(realm, username);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public UserModel addUser(RealmModel realm, String username) {
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
        this.userPasswords.put(UserMapStorage.translateUserName(username), "");
        return this.createUser(realm, username);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY || this.editMode == UserStorageProvider.EditMode.UNSYNCED) {
            log.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'. Deleting user just from Keycloak DB, but he will be re-imported from LDAP again once searched in Keycloak", (Object)user.getUsername(), (Object)this.editMode.toString());
            this.userPasswords.remove(UserMapStorage.translateUserName(user.getUsername()));
            return true;
        }
        return this.userPasswords.remove(UserMapStorage.translateUserName(user.getUsername())) != null;
    }

    public boolean removeUserByName(String userName) {
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY || this.editMode == UserStorageProvider.EditMode.UNSYNCED) {
            log.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'. Deleting user just from Keycloak DB, but he will be re-imported from LDAP again once searched in Keycloak", (Object)userName, (Object)this.editMode.toString());
            this.userPasswords.remove(UserMapStorage.translateUserName(userName));
            return true;
        }
        return this.userPasswords.remove(UserMapStorage.translateUserName(userName)) != null;
    }

    public boolean isImportEnabled() {
        if (this.importEnabled == null) {
            String val = (String)this.model.getConfig().getFirst((Object)"importEnabled");
            this.importEnabled = val == null ? Boolean.valueOf(true) : Boolean.valueOf(val);
        }
        return this.importEnabled;
    }

    public void setImportEnabled(boolean flag) {
        this.importEnabled = flag;
        this.model.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(flag));
    }

    public void preRemove(RealmModel realm) {
        log.infof("preRemove: realm=%s", (Object)realm.getName());
        realmRemovals.incrementAndGet();
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        log.infof("preRemove: realm=%s, group=%s", (Object)realm.getName(), (Object)group.getName());
        groupRemovals.incrementAndGet();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        log.infof("preRemove: realm=%s, role=%s", (Object)realm.getName(), (Object)role.getName());
        roleRemovals.incrementAndGet();
    }

    public void close() {
        closings.incrementAndGet();
    }

    public int getUsersCount(RealmModel realm) {
        return this.userPasswords.size();
    }

    public Stream<UserModel> getUsersStream(RealmModel realm) {
        return this.userPasswords.keySet().stream().map(userName -> this.createUser(realm, (String)userName));
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        Stream userStream = this.userPasswords.keySet().stream().sorted();
        return StreamsUtil.paginatedStream(userStream, (Integer)firstResult, (Integer)maxResults).map(userName -> this.createUser(realm, (String)userName));
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search) {
        String tSearch = UserMapStorage.translateUserName(search);
        return this.userPasswords.keySet().stream().sorted().filter(userName -> UserMapStorage.translateUserName(userName).contains(tSearch)).map(userName -> this.createUser(realm, (String)userName));
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        String tSearch = UserMapStorage.translateUserName(search);
        Stream<String> userStream = this.userPasswords.keySet().stream().sorted().filter(userName -> UserMapStorage.translateUserName(userName).contains(search));
        return StreamsUtil.paginatedStream(userStream, (Integer)firstResult, (Integer)maxResults).map(userName -> this.createUser(realm, (String)userName));
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params, Integer firstResult, Integer maxResults) {
        Stream<Object> userStream = this.userPasswords.keySet().stream().sorted();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            switch (key) {
                case "username": 
                case "keycloak.session.realm.users.query.search": {
                    userStream = Boolean.valueOf(params.getOrDefault("keycloak.session.realm.users.query.exact", Boolean.FALSE.toString())) != false ? userStream.filter(s -> s.toLowerCase().equals(value.toLowerCase())) : userStream.filter(s -> s.toLowerCase().contains(value.toLowerCase()));
                }
            }
        }
        return StreamsUtil.paginatedStream(userStream, (Integer)firstResult, (Integer)maxResults).map(userName -> this.createUser(realm, (String)userName));
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        return this.getMembershipStream(realm, group, firstResult == null ? -1 : firstResult, maxResults == null ? -1 : maxResults).map(userName -> this.createUser(realm, (String)userName));
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        if (this.isImportEnabled()) {
            return this.session.userLocalStorage().searchForUserByUserAttributeStream(realm, attrName, attrValue);
        }
        return this.session.userFederatedStorage().getUsersByUserAttributeStream(realm, attrName, attrValue).map(userName -> this.createUser(realm, (String)userName));
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, String userId) {
        Set set = (Set)this.userGroups.get(UserMapStorage.getUserIdInMap(realm, userId));
        if (set == null) {
            return Stream.empty();
        }
        return set.stream().map(arg_0 -> ((RealmModel)realm).getGroupById(arg_0));
    }

    public void joinGroup(RealmModel realm, String userId, GroupModel group) {
        Set groups = this.userGroups.computeIfAbsent(UserMapStorage.getUserIdInMap(realm, userId), userName -> new ConcurrentSkipListSet());
        groups.add(group.getId());
    }

    public void leaveGroup(RealmModel realm, String userId, GroupModel group) {
        Set set = (Set)this.userGroups.get(UserMapStorage.getUserIdInMap(realm, userId));
        if (set != null) {
            set.remove(group.getId());
        }
    }

    public Stream<String> getMembershipStream(RealmModel realm, GroupModel group, Integer firstResult, Integer max) {
        Stream<String> userStream = StreamsUtil.paginatedStream(this.userGroups.entrySet().stream(), (Integer)firstResult, (Integer)max).filter(me -> ((Set)me.getValue()).contains(group.getId())).map(Map.Entry::getKey).filter(realmUser -> realmUser.startsWith(realm.getId())).map(realmUser -> realmUser.substring(realmUser.indexOf("/") + 1));
        return userStream;
    }

    public UserModel validate(RealmModel realm, UserModel local) {
        boolean userExists = this.userPasswords.containsKey(UserMapStorage.translateUserName(local.getUsername()));
        if (!userExists) {
            this.userGroups.remove(UserMapStorage.getUserIdInMap(realm, local.getUsername()));
        }
        return userExists ? local : null;
    }

    private static String translateUserName(String userName) {
        return userName == null ? null : userName.toLowerCase();
    }
}

