/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.group.GroupStorageProvider;
import org.keycloak.storage.group.GroupStorageProviderModel;

public class HardcodedGroupStorageProvider
implements GroupStorageProvider {
    private final GroupStorageProviderModel component;
    private final String groupName;

    public HardcodedGroupStorageProvider(GroupStorageProviderModel component) {
        this.component = component;
        this.groupName = (String)component.getConfig().getFirst((Object)"gorup_name");
    }

    public void close() {
    }

    public GroupModel getGroupById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        String groupName = storageId.getExternalId();
        if (this.groupName.equals(groupName)) {
            return new HardcodedGroupAdapter(realm);
        }
        return null;
    }

    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        if (Boolean.parseBoolean((String)this.component.getConfig().getFirst((Object)"delayed_search"))) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(HardcodedGroupStorageProvider.class).warn((Object)ex.getCause());
                return Stream.empty();
            }
        }
        if (search != null && this.groupName.toLowerCase().contains(search.toLowerCase())) {
            return Stream.of(new HardcodedGroupAdapter(realm));
        }
        return Stream.empty();
    }

    public class HardcodedGroupAdapter
    implements GroupModel.Streams {
        private final RealmModel realm;
        private StorageId storageId;

        public HardcodedGroupAdapter(RealmModel realm) {
            this.realm = realm;
        }

        public String getId() {
            if (this.storageId == null) {
                this.storageId = new StorageId(HardcodedGroupStorageProvider.this.component.getId(), this.getName());
            }
            return this.storageId.getId();
        }

        public String getName() {
            return HardcodedGroupStorageProvider.this.groupName;
        }

        public Stream<RoleModel> getRealmRoleMappingsStream() {
            return Stream.empty();
        }

        public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
            return Stream.empty();
        }

        public boolean hasRole(RoleModel role) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Stream<RoleModel> getRoleMappingsStream() {
            return Stream.empty();
        }

        public String getFirstAttribute(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Stream<String> getAttributeStream(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<String, List<String>> getAttributes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public GroupModel getParent() {
            return null;
        }

        public String getParentId() {
            return null;
        }

        public Stream<GroupModel> getSubGroupsStream() {
            return Stream.empty();
        }

        public void deleteRoleMapping(RoleModel role) {
            throw new ReadOnlyException("group is read only");
        }

        public void grantRole(RoleModel role) {
            throw new ReadOnlyException("group is read only");
        }

        public void setParent(GroupModel group) {
            throw new ReadOnlyException("group is read only");
        }

        public void addChild(GroupModel subGroup) {
            throw new ReadOnlyException("group is read only");
        }

        public void removeChild(GroupModel subGroup) {
            throw new ReadOnlyException("group is read only");
        }

        public void setName(String name) {
            throw new ReadOnlyException("group is read only");
        }

        public void setSingleAttribute(String name, String value) {
            throw new ReadOnlyException("group is read only");
        }

        public void setAttribute(String name, List<String> values) {
            throw new ReadOnlyException("group is read only");
        }

        public void removeAttribute(String name) {
            throw new ReadOnlyException("group is read only");
        }
    }
}

