/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.client.ClientStorageProviderFactory;
import org.keycloak.storage.client.ClientStorageProviderModel;
import org.keycloak.testsuite.federation.HardcodedClientStorageProvider;

public class HardcodedClientStorageProviderFactory
implements ClientStorageProviderFactory<HardcodedClientStorageProvider> {
    public static final String PROVIDER_ID = "hardcoded-client";
    protected static final List<ProviderConfigProperty> CONFIG_PROPERTIES = ProviderConfigurationBuilder.create().property().name("client_id").type("String").label("Hardcoded Client Id").helpText("Only this client id is available for lookup").defaultValue((Object)"hardcoded-client").add().property().name("redirect_uri").type("String").label("Redirect Uri").helpText("Valid redirect uri.  Only one allowed").defaultValue((Object)"http://localhost:8180/*").add().property().name("consent").type("boolean").label("Consent Required").helpText("Is consent required").defaultValue((Object)"false").add().property().name("delayed_search").type("boolean").label("Delayes provider by 5s.").helpText("If true it delayes search for clients within the provider by 5s.").defaultValue((Object)false).add().build();
    public static final String CLIENT_ID = "client_id";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String CONSENT = "consent";
    public static final String DELAYED_SEARCH = "delayed_search";

    public HardcodedClientStorageProvider create(KeycloakSession session, ComponentModel model) {
        return new HardcodedClientStorageProvider(session, new ClientStorageProviderModel(model));
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }
}

