/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.ImportSynchronization;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.federation.FailableHardcodedStorageProvider;

public class FailableHardcodedStorageProviderFactory
implements UserStorageProviderFactory<FailableHardcodedStorageProvider>,
ImportSynchronization {
    public static final String PROVIDER_ID = "failable-hardcoded-storage";
    static List<ProviderConfigProperty> OPTIONS = new LinkedList<ProviderConfigProperty>();

    public FailableHardcodedStorageProvider create(KeycloakSession session, ComponentModel model) {
        return new FailableHardcodedStorageProvider(model, session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return OPTIONS;
    }

    public SynchronizationResult sync(KeycloakSessionFactory sessionFactory, String realmId, UserStorageProviderModel model) {
        if (FailableHardcodedStorageProvider.isInFailMode((ComponentModel)model)) {
            FailableHardcodedStorageProvider.throwFailure();
        }
        return SynchronizationResult.empty();
    }

    public SynchronizationResult syncSince(Date lastSync, KeycloakSessionFactory sessionFactory, String realmId, UserStorageProviderModel model) {
        if (FailableHardcodedStorageProvider.isInFailMode((ComponentModel)model)) {
            FailableHardcodedStorageProvider.throwFailure();
        }
        return SynchronizationResult.empty();
    }

    static {
        ProviderConfigProperty prop = new ProviderConfigProperty("fail", "fail", "If on, provider will throw exception", "boolean", (Object)"false");
        OPTIONS.add(prop);
    }
}

