/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.adapter.AbstractUserAdapterFederatedStorage;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class BackwardsCompatibilityUserStorage
implements UserLookupProvider,
UserStorageProvider,
UserRegistrationProvider,
CredentialInputUpdater,
CredentialInputValidator,
UserQueryProvider {
    private static final Logger log = Logger.getLogger(BackwardsCompatibilityUserStorage.class);
    protected final Map<String, MyUser> users;
    protected final ComponentModel model;
    protected final KeycloakSession session;

    public BackwardsCompatibilityUserStorage(KeycloakSession session, ComponentModel model, Map<String, MyUser> users) {
        this.session = session;
        this.model = model;
        this.users = users;
    }

    private static String translateUserName(String userName) {
        return userName == null ? null : userName.toLowerCase();
    }

    public UserModel getUserById(String id, RealmModel realm) {
        StorageId storageId = new StorageId(id);
        String username = storageId.getExternalId();
        if (!this.users.containsKey(BackwardsCompatibilityUserStorage.translateUserName(username))) {
            return null;
        }
        return this.createUser(realm, username);
    }

    private UserModel createUser(RealmModel realm, final String username) {
        return new AbstractUserAdapterFederatedStorage(this.session, realm, this.model){

            public String getUsername() {
                return username;
            }

            public void setUsername(String username1) {
                if (!username1.equals(username)) {
                    throw new RuntimeException("Unsupported to change username");
                }
            }
        };
    }

    public boolean supportsCredentialType(String credentialType) {
        if ("password".equals(credentialType) || this.isOTPType(credentialType)) {
            return true;
        }
        log.infof("Unsupported credential type: %s", (Object)credentialType);
        return false;
    }

    private boolean isOTPType(String credentialType) {
        return "otp".equals(credentialType) || "hotp".equals(credentialType) || "totp".equals(credentialType);
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password")) {
            if (!(input instanceof PasswordUserCredentialModel)) {
                log.warn((Object)"Input is not PasswordUserCredentialModel");
                return false;
            }
            PasswordUserCredentialModel userCredentialModel = (PasswordUserCredentialModel)input;
            this.assertNull(userCredentialModel.getDevice());
            this.assertNull(userCredentialModel.getAlgorithm());
            PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
            PasswordHashProvider hashProvider = this.getHashProvider(policy);
            CredentialModel newPassword = new CredentialModel();
            newPassword.setType("password");
            long createdDate = Time.currentTimeMillis();
            newPassword.setCreatedDate(Long.valueOf(createdDate));
            hashProvider.encode(userCredentialModel.getValue(), policy.getHashIterations(), newPassword);
            this.assertEquals(newPassword.getAlgorithm(), policy.getHashAlgorithm());
            this.assertNotNull(newPassword.getValue());
            this.assertNotNull(newPassword.getSalt());
            this.users.get(BackwardsCompatibilityUserStorage.translateUserName(user.getUsername())).hashedPassword = newPassword;
            UserCache userCache = this.session.userCache();
            if (userCache != null) {
                userCache.evict(realm, user);
            }
            return true;
        }
        if (this.isOTPType(input.getType())) {
            UserCredentialModel otpCredential = (UserCredentialModel)input;
            this.assertNull(otpCredential.getDevice());
            this.assertNull(otpCredential.getAlgorithm());
            OTPPolicy otpPolicy = this.session.getContext().getRealm().getOTPPolicy();
            CredentialModel newOTP = new CredentialModel();
            newOTP.setType(input.getType());
            long createdDate = Time.currentTimeMillis();
            newOTP.setCreatedDate(Long.valueOf(createdDate));
            newOTP.setValue(otpCredential.getValue());
            newOTP.setCounter(otpPolicy.getInitialCounter());
            newOTP.setDigits(otpPolicy.getDigits());
            newOTP.setAlgorithm(otpPolicy.getAlgorithm());
            newOTP.setPeriod(otpPolicy.getPeriod());
            this.users.get(BackwardsCompatibilityUserStorage.translateUserName(user.getUsername())).otp = newOTP;
            return true;
        }
        log.infof("Attempt to update unsupported credential of type: %s", (Object)input.getType());
        return false;
    }

    protected PasswordHashProvider getHashProvider(PasswordPolicy policy) {
        PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, policy.getHashAlgorithm());
        if (hash == null) {
            log.warnv("Realm PasswordPolicy PasswordHashProvider {0} not found", (Object)policy.getHashAlgorithm());
            return (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, "pbkdf2-sha256");
        }
        return hash;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
        if (this.isOTPType(credentialType)) {
            MyUser myUser = this.getMyUser(user);
            myUser.otp = null;
        } else {
            log.infof("Unsupported to disable credential of type: %s", (Object)credentialType);
        }
    }

    private MyUser getMyUser(UserModel user) {
        return this.users.get(BackwardsCompatibilityUserStorage.translateUserName(user.getUsername()));
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        HashSet<String> types = new HashSet<String>();
        MyUser myUser = this.getMyUser(user);
        if (myUser != null && myUser.otp != null) {
            types.add("otp");
        }
        return types;
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if ("password".equals(credentialType)) {
            return true;
        }
        MyUser myUser = this.getMyUser(user);
        if (myUser == null) {
            return false;
        }
        if (this.isOTPType(credentialType) && myUser.otp != null) {
            return true;
        }
        log.infof("Not supported credentialType '%s' for user '%s'", (Object)credentialType, (Object)user.getUsername());
        return false;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        MyUser myUser = this.users.get(BackwardsCompatibilityUserStorage.translateUserName(user.getUsername()));
        if (myUser == null) {
            return false;
        }
        if (input.getType().equals("password")) {
            if (!(input instanceof PasswordUserCredentialModel)) {
                return false;
            }
            CredentialModel hashedPassword = myUser.hashedPassword;
            if (hashedPassword == null) {
                log.warnf("Password not set for user %s", (Object)user.getUsername());
                return false;
            }
            PasswordUserCredentialModel userCredentialModel = (PasswordUserCredentialModel)input;
            this.assertNull(userCredentialModel.getDevice());
            this.assertNull(userCredentialModel.getAlgorithm());
            PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
            PasswordHashProvider hashProvider = this.getHashProvider(policy);
            String rawPassword = userCredentialModel.getValue();
            return hashProvider.verify(rawPassword, hashedPassword);
        }
        if (this.isOTPType(input.getType())) {
            UserCredentialModel otpCredential = (UserCredentialModel)input;
            if ("123456".equals(otpCredential.getValue())) {
                return true;
            }
            CredentialModel storedOTPCredential = myUser.otp;
            if (storedOTPCredential == null) {
                log.warnf("Not found credential for the user %s", (Object)user.getUsername());
                return false;
            }
            TimeBasedOTP validator = new TimeBasedOTP(storedOTPCredential.getAlgorithm(), storedOTPCredential.getDigits(), storedOTPCredential.getPeriod(), realm.getOTPPolicy().getLookAheadWindow());
            return validator.validateTOTP(otpCredential.getValue(), storedOTPCredential.getValue().getBytes());
        }
        log.infof("Not supported to validate credential of type '%s' for user '%s'", (Object)input.getType(), (Object)user.getUsername());
        return false;
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        if (!this.users.containsKey(BackwardsCompatibilityUserStorage.translateUserName(username))) {
            return null;
        }
        return this.createUser(realm, username);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        return null;
    }

    public UserModel addUser(RealmModel realm, String username) {
        this.users.put(BackwardsCompatibilityUserStorage.translateUserName(username), new MyUser(username));
        return this.createUser(realm, username);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.users.remove(BackwardsCompatibilityUserStorage.translateUserName(user.getUsername())) != null;
    }

    public int getUsersCount(RealmModel realm) {
        return this.users.size();
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, -1, -1);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.users.values().stream().skip(firstResult).limit(maxResults).map(myUser -> this.createUser(realm, ((MyUser)myUser).username)).collect(Collectors.toList());
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        UserModel user = this.getUserByUsername(realm, search);
        return user == null ? Collections.emptyList() : Arrays.asList(user);
    }

    public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm) {
        return Collections.emptyList();
    }

    public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm, int firstResult, int maxResults) {
        return Collections.emptyList();
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        return Collections.emptyList();
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return Collections.emptyList();
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        return Collections.emptyList();
    }

    public void close() {
    }

    private void assertNull(Object obj) {
        if (obj != null) {
            throw new AssertionError((Object)"Object wasn't null");
        }
    }

    private void assertNotNull(Object obj) {
        if (obj == null) {
            throw new AssertionError((Object)"Object was null");
        }
    }

    private void assertEquals(Object obj1, Object obj2) {
        if (!obj1.equals(obj2)) {
            throw new AssertionError((Object)"Objects not equals");
        }
    }

    static class MyUser {
        private String username;
        private CredentialModel hashedPassword;
        private CredentialModel otp;

        private MyUser(String username) {
            this.username = username;
        }

        public CredentialModel getOtp() {
            return this.otp;
        }
    }
}

