/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.domainextension.rest;

import java.net.URI;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.testsuite.domainextension.CompanyRepresentation;
import org.keycloak.testsuite.domainextension.spi.ExampleService;

public class CompanyResource {
    private final KeycloakSession session;

    public CompanyResource(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @Path(value="")
    @NoCache
    @Produces(value={"application/json"})
    public List<CompanyRepresentation> getCompanies() {
        return ((ExampleService)this.session.getProvider(ExampleService.class)).listCompanies();
    }

    @DELETE
    @Path(value="")
    @NoCache
    public void deleteAllCompanies() {
        ((ExampleService)this.session.getProvider(ExampleService.class)).deleteAllCompanies();
    }

    @POST
    @Path(value="")
    @NoCache
    @Consumes(value={"application/json"})
    public Response createCompany(CompanyRepresentation rep) {
        ((ExampleService)this.session.getProvider(ExampleService.class)).addCompany(rep);
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(rep.getId()).build(new Object[0])).build();
    }

    @GET
    @NoCache
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public CompanyRepresentation getCompany(@PathParam(value="id") String id) {
        return ((ExampleService)this.session.getProvider(ExampleService.class)).findCompany(id);
    }
}

