/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.components.amphibian;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.testsuite.components.amphibian.TestAmphibianProvider;
import org.keycloak.testsuite.components.amphibian.TestAmphibianProviderFactory;

public class TestAmphibianProviderFactoryImpl
implements TestAmphibianProviderFactory {
    public static final String PROVIDER_ID = "test";
    private static final List<ProviderConfigProperty> CONFIG = ProviderConfigurationBuilder.create().property("secret", "Secret", "A secret value", "String", null, null, true).property("number", "Number", "A number value", "String", null, null, false).property("required", "Required", "A required value", "String", null, null, false).property("val1", "Value 1", "Some more values", "String", null, null, false).property("val2", "Value 2", "Some more values", "String", null, null, false).property("val3", "Value 3", "Some more values", "String", null, null, false).build();
    private String secret;
    private Integer number;
    private String required;
    private String val1;
    private String val2;
    private String val3;

    public TestImplProvider create(KeycloakSession session) {
        return new TestImplProvider();
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkRequired("required", "Required").checkInt("number", "Number", false);
    }

    public String getHelpText() {
        return "Provider to test component invalidation";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG;
    }

    public void init(Config.Scope config) {
        this.secret = config.get("secret");
        this.number = config.getInt("number");
        this.required = config.get("required");
        this.val1 = config.get("val1");
        this.val2 = config.get("val2");
        this.val3 = config.get("val3");
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public class TestImplProvider
    implements TestAmphibianProvider {
        @Override
        public Map<String, Object> getDetails() {
            HashMap<String, Object> c = new HashMap<String, Object>();
            c.put("secret", TestAmphibianProviderFactoryImpl.this.secret);
            c.put("number", TestAmphibianProviderFactoryImpl.this.number);
            c.put("required", TestAmphibianProviderFactoryImpl.this.required);
            c.put("val1", TestAmphibianProviderFactoryImpl.this.val1);
            c.put("val2", TestAmphibianProviderFactoryImpl.this.val2);
            c.put("val3", TestAmphibianProviderFactoryImpl.this.val3);
            return c;
        }

        public void close() {
        }
    }
}

