/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authentication;

import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelProvider;
import org.keycloak.protocol.oidc.grants.ciba.channel.HttpAuthenticationChannelProvider;
import org.keycloak.protocol.oidc.grants.ciba.channel.HttpAuthenticationChannelProviderFactory;
import org.keycloak.testsuite.util.ServerURLs;

public class TestHttpAuthenticationChannelProviderFactory
extends HttpAuthenticationChannelProviderFactory {
    private static final String TEST_HTTP_AUTH_CHANNEL = String.format("%s://%s:%s/auth/realms/master/app/oidc-client-endpoints/request-authentication-channel", ServerURLs.AUTH_SERVER_SCHEME, ServerURLs.AUTH_SERVER_HOST, ServerURLs.AUTH_SERVER_PORT);

    public AuthenticationChannelProvider create(KeycloakSession session) {
        return new HttpAuthenticationChannelProvider(session, TEST_HTTP_AUTH_CHANNEL);
    }

    public int order() {
        return 100;
    }

    public String getId() {
        return "test-http-auth-channel";
    }

    public boolean isSupported() {
        return true;
    }
}

