/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authentication;

import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.DisplayTypeAuthenticatorFactory;
import org.keycloak.authentication.authenticators.AttemptedAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.testsuite.authentication.SetUserAttributeAuthenticator;

public class SetUserAttributeAuthenticatorFactory
implements AuthenticatorFactory,
DisplayTypeAuthenticatorFactory {
    public static final String PROVIDER_ID = "set-attribute";
    public static final String CONF_ATTR_NAME = "attr_name";
    public static final String CONF_ATTR_VALUE = "attr_value";
    protected static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public Authenticator createDisplay(KeycloakSession keycloakSession, String displayType) {
        if (displayType == null) {
            return this.create(keycloakSession);
        }
        if (!"console".equalsIgnoreCase(displayType)) {
            return null;
        }
        return AttemptedAuthenticator.SINGLETON;
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getHelpText() {
        return "Set a user attribute";
    }

    public void init(Config.Scope scope) {
    }

    public void postInit(KeycloakSessionFactory keycloakSessionFactory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession keycloakSession) {
        return new SetUserAttributeAuthenticator();
    }

    public String getDisplayType() {
        return "Set user attribute";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty attributeName = new ProviderConfigProperty();
        attributeName.setType("String");
        attributeName.setName(CONF_ATTR_NAME);
        attributeName.setLabel("Attribute name");
        attributeName.setHelpText("Name of the user attribute to set");
        ProviderConfigProperty attributeValue = new ProviderConfigProperty();
        attributeValue.setType("String");
        attributeValue.setName(CONF_ATTR_VALUE);
        attributeValue.setLabel("Attribute value");
        attributeValue.setHelpText("Value to set in the user attribute");
        return Arrays.asList(attributeName, attributeValue);
    }
}

