/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authentication;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class SetUserAttributeAuthenticator
implements Authenticator {
    public void authenticate(AuthenticationFlowContext context) {
        Map config = context.getAuthenticatorConfig().getConfig();
        String attrName = (String)config.get("attr_name");
        String attrValue = (String)config.get("attr_value");
        UserModel user = context.getUser();
        List attrValues = user.getAttributeStream(attrName).collect(Collectors.toList());
        if (attrValues.isEmpty()) {
            user.setSingleAttribute(attrName, attrValue);
        } else {
            if (!attrValues.contains(attrValue)) {
                attrValues.add(attrValue);
            }
            user.setAttribute(attrName, attrValues);
        }
        context.success();
    }

    public void action(AuthenticationFlowContext context) {
        context.failure(AuthenticationFlowError.INTERNAL_ERROR);
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

