/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authentication;

import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class PushButtonAuthenticator
implements Authenticator {
    public void authenticate(AuthenticationFlowContext context) {
        String accessCode = context.generateAccessCode();
        String actionUrl = context.getActionUrl(accessCode).toString();
        StringBuilder response = new StringBuilder("<html><head><title>PushTheButton</title></head><body>");
        UserModel user = context.getUser();
        if (user == null) {
            response.append("No authenticated user<br>");
        } else {
            response.append("Authenticated user: " + user.getUsername() + "<br>");
        }
        response.append("<form method='POST' action='" + actionUrl + "'>");
        response.append(" This is the Test Approver. Press login to continue.<br>");
        response.append(" <input type='submit' name='submit1' value='Submit' />");
        response.append("</form></body></html>");
        String html = response.toString();
        Response jaxrsResponse = Response.status((Response.Status)Response.Status.OK).type("text/html").entity((Object)html).build();
        context.challenge(jaxrsResponse);
    }

    public void action(AuthenticationFlowContext context) {
        context.success();
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

