/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.net.URI;
import java.util.function.Supplier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;

public class IdPInitiatedLoginBuilder
implements SamlClient.Step {
    private final SamlClientBuilder clientBuilder;
    private final URI authServerSamlUrl;
    private final String clientId;
    private Supplier<String> relayState;

    public IdPInitiatedLoginBuilder(URI authServerSamlUrl, String clientId, SamlClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
        this.authServerSamlUrl = authServerSamlUrl;
        this.clientId = clientId;
    }

    @Override
    public HttpUriRequest perform(CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) throws Exception {
        return new HttpGet(this.authServerSamlUrl.toString() + "/clients/" + this.clientId + this.getRelayStateQueryParamString());
    }

    private String getRelayStateQueryParamString() {
        if (this.relayState == null) {
            return "";
        }
        return "?RelayState=" + this.relayState.get();
    }

    public IdPInitiatedLoginBuilder relayState(String relayState) {
        this.relayState = () -> relayState;
        return this;
    }

    public IdPInitiatedLoginBuilder relayState(Supplier<String> relayState) {
        this.relayState = relayState;
        return this;
    }

    public SamlClientBuilder build() {
        return this.clientBuilder;
    }
}

