/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import javax.xml.stream.XMLStreamWriter;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.infinispan.util.function.SerializableFunction;
import org.junit.Assert;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResolveType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.SamlArtifactSessionMappingStoreProvider;
import org.keycloak.protocol.saml.profile.util.Soap;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLRequestWriter;
import org.keycloak.testsuite.util.KeyUtils;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.SamlDocumentStepBuilder;
import org.keycloak.testsuite.util.saml.SessionStateChecker;
import org.keycloak.testsuite.util.saml.StepWithCheckers;
import org.w3c.dom.Document;

public class HandleArtifactStepBuilder
extends SamlDocumentStepBuilder<ArtifactResolveType, HandleArtifactStepBuilder>
implements StepWithCheckers {
    private String signingPrivateKeyPem;
    private String signingPublicKeyPem;
    private String id = IDGenerator.create((String)"ID_");
    private String issuer;
    private final URI authServerSamlUrl;
    private boolean verifyRedirect;
    private HttpPost replayPostMessage;
    private boolean replayPost;
    private boolean replayArtifact;
    private AtomicReference<String> providedArtifact;
    private AtomicReference<String> storeArtifact;
    private Runnable beforeStepChecker;
    private Runnable afterStepChecker;
    private static final Pattern artifactPattern = Pattern.compile("NAME=\"SAMLart\" VALUE=\"([A-Za-z0-9+=/]*)\"");

    public HandleArtifactStepBuilder(URI authServerSamlUrl, String issuer, SamlClientBuilder clientBuilder) {
        super(clientBuilder);
        this.issuer = issuer;
        this.authServerSamlUrl = authServerSamlUrl.toString().endsWith("resolve") ? authServerSamlUrl : UriBuilder.fromUri((URI)authServerSamlUrl).path("resolve").build(new Object[0]);
        this.verifyRedirect = false;
    }

    public HandleArtifactStepBuilder signWith(String signingPrivateKeyPem, String signingPublicKeyPem) {
        this.signingPrivateKeyPem = signingPrivateKeyPem;
        this.signingPublicKeyPem = signingPublicKeyPem;
        return this;
    }

    public HandleArtifactStepBuilder issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public HandleArtifactStepBuilder setBeforeStepChecks(Runnable checker) {
        this.beforeStepChecker = checker;
        return this;
    }

    public HandleArtifactStepBuilder setAfterStepChecks(Runnable checker) {
        this.afterStepChecker = checker;
        return this;
    }

    public HandleArtifactStepBuilder verifyRedirect(boolean verifyRedirect) {
        this.verifyRedirect = verifyRedirect;
        return this;
    }

    public HandleArtifactStepBuilder replayPost(boolean mustReplayPost) {
        this.replayPost = mustReplayPost;
        return this;
    }

    public HandleArtifactStepBuilder storeArtifact(AtomicReference<String> storeArtifact) {
        this.storeArtifact = storeArtifact;
        return this;
    }

    public HandleArtifactStepBuilder useArtifact(AtomicReference<String> artifact) {
        this.providedArtifact = artifact;
        return this;
    }

    public HandleArtifactStepBuilder setArtifactResolveId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public HttpUriRequest perform(CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) throws Exception {
        HttpPost post;
        if (this.replayPost && this.replayPostMessage != null) {
            return this.replayPostMessage;
        }
        ArtifactResolveType artifactResolve = new ArtifactResolveType(this.id, XMLTimeUtil.getIssueInstant());
        NameIDType nameIDType = new NameIDType();
        nameIDType.setValue(this.issuer);
        artifactResolve.setIssuer(nameIDType);
        String artifact = this.getArtifactFromResponse(currentResponse);
        if (this.storeArtifact != null) {
            this.storeArtifact.set(artifact);
        }
        artifactResolve.setArtifact(artifact);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter xmlStreamWriter = StaxUtil.getXMLStreamWriter((OutputStream)bos);
        new SAMLRequestWriter(xmlStreamWriter).write(artifactResolve);
        Document doc = DocumentUtil.getDocument((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
        if (this.signingPrivateKeyPem != null && this.signingPublicKeyPem != null) {
            PrivateKey privateKey = KeyUtils.privateKeyFromString(this.signingPrivateKeyPem);
            PublicKey publicKey = KeyUtils.publicKeyFromString(this.signingPublicKeyPem);
            binding.signatureAlgorithm(SignatureAlgorithm.RSA_SHA256).signWith(org.keycloak.common.util.KeyUtils.createKeyId((Key)privateKey), privateKey, publicKey).signDocument(doc);
        }
        String documentAsString = DocumentUtil.getDocumentAsString((Document)doc);
        String transformed = this.getTransformer().transform(documentAsString);
        if (transformed == null) {
            return null;
        }
        if (this.beforeStepChecker != null && this.beforeStepChecker instanceof SessionStateChecker) {
            SessionStateChecker sessionStateChecker = (SessionStateChecker)this.beforeStepChecker;
            sessionStateChecker.setUserSessionProvider((SerializableFunction<KeycloakSession, String>)(SerializableFunction & Serializable)session -> ((SamlArtifactSessionMappingStoreProvider)session.getProvider(SamlArtifactSessionMappingStoreProvider.class)).get(artifact).getUserSessionId());
            sessionStateChecker.setClientSessionProvider((SerializableFunction<KeycloakSession, String>)(SerializableFunction & Serializable)session -> ((SamlArtifactSessionMappingStoreProvider)session.getProvider(SamlArtifactSessionMappingStoreProvider.class)).get(artifact).getClientSessionId());
        }
        this.replayPostMessage = post = Soap.createMessage().addToBody(DocumentUtil.getDocument((String)transformed)).buildHttpPost(this.authServerSamlUrl);
        return post;
    }

    private String getArtifactFromResponse(CloseableHttpResponse currentResponse) throws IOException {
        if (this.providedArtifact != null) {
            return this.providedArtifact.get();
        }
        if (currentResponse.getFirstHeader("location") != null) {
            String location = currentResponse.getFirstHeader("location").getValue();
            List params = URLEncodedUtils.parse((URI)URI.create(location), (Charset)Charset.forName("UTF-8"));
            for (NameValuePair param : params) {
                String artifact;
                if (!"SAMLart".equals(param.getName()) || (artifact = param.getValue()) == null || artifact.isEmpty()) continue;
                return artifact;
            }
        }
        Assert.assertFalse((boolean)this.verifyRedirect);
        String form = EntityUtils.toString((HttpEntity)currentResponse.getEntity());
        Matcher m = artifactPattern.matcher(form);
        Assert.assertTrue((String)("Can't find artifact in " + form), (boolean)m.find());
        return m.group(1);
    }

    @Override
    public Runnable getBeforeStepChecker() {
        return this.beforeStepChecker;
    }

    @Override
    public Runnable getAfterStepChecker() {
        return this.afterStepChecker;
    }
}

