/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.matchers;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;

public class SamlStatusResponseTypeMatcher
extends BaseMatcher<SAML2Object> {
    private final List<Matcher<URI>> statusMatchers;

    public SamlStatusResponseTypeMatcher(URI ... statusMatchers) {
        this.statusMatchers = new ArrayList<Matcher<URI>>(statusMatchers.length);
        for (URI uri : statusMatchers) {
            this.statusMatchers.add((Matcher<URI>)Matchers.is((Object)uri));
        }
    }

    public SamlStatusResponseTypeMatcher(List<Matcher<URI>> statusMatchers) {
        this.statusMatchers = statusMatchers;
    }

    public boolean matches(Object item) {
        StatusCodeType statusCode = ((StatusResponseType)item).getStatus().getStatusCode();
        for (Matcher<URI> statusMatcher : this.statusMatchers) {
            if (!statusMatcher.matches((Object)statusCode.getValue())) {
                return false;
            }
            statusCode = statusCode.getStatusCode();
        }
        return true;
    }

    public void describeMismatch(Object item, Description description) {
        description.appendText("was ");
        for (StatusCodeType statusCode = ((StatusResponseType)item).getStatus().getStatusCode(); statusCode != null; statusCode = statusCode.getStatusCode()) {
            description.appendText("/").appendValue((Object)statusCode.getValue());
        }
    }

    public void describeTo(Description description) {
        description.appendText("SAML status response status matches ");
        for (Matcher<URI> statusMatcher : this.statusMatchers) {
            description.appendText("/").appendDescriptionOf(statusMatcher);
        }
    }
}

