/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.matchers;

import java.net.URI;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;

public class SamlResponseTypeMatcher
extends BaseMatcher<SAML2Object> {
    private final Matcher<URI> statusMatcher;

    public SamlResponseTypeMatcher(JBossSAMLURIConstants expectedStatus) {
        this.statusMatcher = Matchers.is((Object)expectedStatus.getUri());
    }

    public SamlResponseTypeMatcher(Matcher<URI> statusMatcher) {
        this.statusMatcher = statusMatcher;
    }

    public boolean matches(Object item) {
        return this.statusMatcher.matches((Object)((ResponseType)item).getStatus().getStatusCode().getValue());
    }

    public void describeMismatch(Object item, Description description) {
        description.appendText("was ").appendValue((Object)((ResponseType)item).getStatus().getStatusCode());
    }

    public void describeTo(Description description) {
        description.appendText("SAML response status code matches ").appendDescriptionOf(this.statusMatcher);
    }
}

