/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.matchers;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class HttpResponseStatusCodeMatcher
extends BaseMatcher<HttpResponse> {
    private final Matcher<? extends Number> matcher;

    public HttpResponseStatusCodeMatcher(Matcher<? extends Number> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(Object item) {
        return item instanceof HttpResponse && this.matcher.matches((Object)((HttpResponse)item).getStatusLine().getStatusCode());
    }

    public void describeMismatch(Object item, Description description) {
        Description d = description.appendText("was ").appendValue(item).appendText(" with entity ");
        try {
            d.appendText(EntityUtils.toString((HttpEntity)((HttpResponse)item).getEntity()));
        }
        catch (IOException e) {
            d.appendText("<Cannot decode entity: " + e.getMessage() + ">");
        }
    }

    public void describeTo(Description description) {
        description.appendText("response status code matches ").appendDescriptionOf(this.matcher);
    }
}

