/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.javascript;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.util.javascript.JSObjectBuilder;
import org.keycloak.testsuite.util.javascript.JavascriptStateValidator;
import org.keycloak.testsuite.util.javascript.ResponseValidator;
import org.keycloak.testsuite.util.javascript.XMLHttpRequest;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class JavascriptTestExecutor {
    protected WebDriver jsDriver;
    protected JavascriptExecutor jsExecutor;
    private WebElement output;
    protected WebElement events;
    private OIDCLogin loginPage;
    protected boolean configured;

    public static JavascriptTestExecutor create(WebDriver driver, OIDCLogin loginPage) {
        return new JavascriptTestExecutor(driver, loginPage);
    }

    protected JavascriptTestExecutor(WebDriver driver, OIDCLogin loginPage) {
        this.jsDriver = driver;
        driver.manage().timeouts().setScriptTimeout((long)WaitUtils.PAGELOAD_TIMEOUT_MILLIS.intValue(), TimeUnit.MILLISECONDS);
        this.jsExecutor = (JavascriptExecutor)driver;
        this.events = driver.findElement(By.id((String)"events"));
        this.output = driver.findElement(By.id((String)"output"));
        this.loginPage = loginPage;
        this.configured = false;
    }

    public JavascriptTestExecutor login() {
        return this.login((String)null, null);
    }

    public JavascriptTestExecutor login(JavascriptStateValidator validator) {
        return this.login((String)null, validator);
    }

    public JavascriptTestExecutor attachCheck3pCookiesIframeMutationObserver() {
        this.jsExecutor.executeScript("// Select the node that will be observed for mutations\n    const targetNode = document.body;    // Options for the observer (which mutations to observe)\n    const config = {attributes: true, childList: true, subtree: true};    // Callback function to execute when mutations are observed\n    const callback = function (mutationsList, observer) {        console.log(\"Mutation found\");        var iframeNode = mutationsList[0].addedNodes[0];                if (iframeNode && iframeNode.localName === 'iframe') {                    var s = document.createElement('script');                    s.type = 'text/javascript';                    var code = \"window.parent.postMessage('Evil Message', '*');\";                    s.appendChild(document.createTextNode(code));                    iframeNode.contentDocument.body.appendChild(s);                }    }\n    // Create an observer instance linked to the callback function\n    const observer = new MutationObserver(callback);    // Start observing the target node for configured mutations\n    observer.observe(targetNode, config);", new Object[0]);
        return this;
    }

    public JavascriptTestExecutor login(JSObjectBuilder optionsBuilder, JavascriptStateValidator validator) {
        return this.login(optionsBuilder.build(), validator);
    }

    public JavascriptTestExecutor login(String options, JavascriptStateValidator validator) {
        if (options == null) {
            this.jsExecutor.executeScript("keycloak.login()", new Object[0]);
        } else {
            this.jsExecutor.executeScript("keycloak.login(" + options + ")", new Object[0]);
        }
        WaitUtils.waitForPageToLoad();
        if (validator != null) {
            validator.validate(this.jsDriver, this.output, this.events);
        }
        this.configured = false;
        return this;
    }

    public JavascriptTestExecutor loginForm(UserRepresentation user) {
        return this.loginForm(user, null);
    }

    public JavascriptTestExecutor loginForm(UserRepresentation user, JavascriptStateValidator validator) {
        this.loginPage.form().login(user);
        WaitUtils.waitForPageToLoad();
        if (validator != null) {
            validator.validate(this.jsDriver, null, this.events);
        }
        this.configured = false;
        return this;
    }

    public JavascriptTestExecutor logout() {
        return this.logout(null);
    }

    public JavascriptTestExecutor logout(JavascriptStateValidator validator) {
        this.jsExecutor.executeScript("keycloak.logout()", new Object[0]);
        if (validator != null) {
            validator.validate(this.jsDriver, this.output, this.events);
        }
        this.configured = false;
        return this;
    }

    public JavascriptTestExecutor configure() {
        return this.configure(null);
    }

    public JavascriptTestExecutor configure(JSObjectBuilder argumentsBuilder) {
        this.jsExecutor.executeScript("console.warn = event;", new Object[0]);
        if (argumentsBuilder == null) {
            this.jsExecutor.executeScript("window.keycloak = Keycloak();", new Object[0]);
        } else {
            String configArguments = argumentsBuilder.build();
            this.jsExecutor.executeScript("window.keycloak = Keycloak(" + configArguments + ");", new Object[0]);
        }
        this.jsExecutor.executeScript("window.keycloak.onAuthSuccess = function () {event('Auth Success')};", new Object[0]);
        this.jsExecutor.executeScript("window.keycloak.onAuthError = function () {event('Auth Error')}", new Object[0]);
        this.jsExecutor.executeScript("window.keycloak.onAuthRefreshSuccess = function () {event('Auth Refresh Success')}", new Object[0]);
        this.jsExecutor.executeScript("window.keycloak.onAuthRefreshError = function () {event('Auth Refresh Error')}", new Object[0]);
        this.jsExecutor.executeScript("window.keycloak.onAuthLogout = function () {event('Auth Logout')}", new Object[0]);
        this.jsExecutor.executeScript("window.keycloak.onTokenExpired = function () {event('Access token expired.')}", new Object[0]);
        this.jsExecutor.executeScript("window.keycloak.onActionUpdate = function (status) {event('AIA status: ' + status)}", new Object[0]);
        this.configured = true;
        return this;
    }

    public JavascriptTestExecutor init(JSObjectBuilder argumentsBuilder) {
        return this.init(argumentsBuilder, null);
    }

    public JavascriptTestExecutor init(JSObjectBuilder argumentsBuilder, JavascriptStateValidator validator) {
        return this.init(argumentsBuilder, validator, false);
    }

    public JavascriptTestExecutor init(JSObjectBuilder argumentsBuilder, JavascriptStateValidator validator, boolean expectPromptNoneRedirect) {
        Object output;
        if (!this.configured) {
            this.configure();
        }
        String arguments = argumentsBuilder.build();
        String script = "var callback = arguments[arguments.length - 1];   window.keycloak.init(" + arguments + ").then(function (authenticated) {       callback(\"Init Success (\" + (authenticated ? \"Authenticated\" : \"Not Authenticated\") + \")\");   }).catch(function (error) {       callback(error);   });";
        if (expectPromptNoneRedirect) {
            try {
                output = this.jsExecutor.executeAsyncScript(script, new Object[0]);
                Assert.fail((String)"Redirect to Keycloak was expected");
            }
            catch (WebDriverException e) {
                WaitUtils.waitForPageToLoad();
                this.configured = false;
                return this.init(argumentsBuilder, validator, false);
            }
        } else {
            output = this.jsExecutor.executeAsyncScript(script, new Object[0]);
        }
        if (validator != null) {
            validator.validate(this.jsDriver, output, this.events);
        }
        return this;
    }

    public JavascriptTestExecutor logInAndInit(JSObjectBuilder argumentsBuilder, UserRepresentation user, JavascriptStateValidator validator) {
        this.init(argumentsBuilder);
        this.login();
        this.loginForm(user);
        this.init(argumentsBuilder, validator);
        return this;
    }

    public JavascriptTestExecutor refreshToken(int value) {
        return this.refreshToken(value, null);
    }

    public JavascriptTestExecutor refreshToken(int value, JavascriptStateValidator validator) {
        String script = "var callback = arguments[arguments.length - 1];   window.keycloak.updateToken(" + Integer.toString(value) + ").then(function (refreshed) {       if (refreshed) {            callback(window.keycloak.tokenParsed);       } else {            callback('Token not refreshed, valid for ' + Math.round(window.keycloak.tokenParsed.exp + window.keycloak.timeSkew - new Date().getTime() / 1000) + ' seconds');       }   }).catch(function () {       callback('Failed to refresh token');   });";
        Object output = this.jsExecutor.executeAsyncScript(script, new Object[0]);
        if (validator != null) {
            validator.validate(this.jsDriver, output, this.events);
        }
        return this;
    }

    public JavascriptTestExecutor openAccountPage(JavascriptStateValidator validator) {
        this.jsExecutor.executeScript("window.keycloak.accountManagement()", new Object[0]);
        WaitUtils.waitForPageToLoad();
        this.configured = false;
        if (validator != null) {
            validator.validate(this.jsDriver, null, null);
        }
        return this;
    }

    public JavascriptTestExecutor getProfile() {
        return this.getProfile(null);
    }

    public JavascriptTestExecutor getProfile(JavascriptStateValidator validator) {
        String script = "var callback = arguments[arguments.length - 1];   window.keycloak.loadUserProfile().then(function (profile) {       callback(profile);   }, function () {       callback('Failed to load profile');   });";
        Object output = this.jsExecutor.executeAsyncScript(script, new Object[0]);
        if (validator != null) {
            validator.validate(this.jsDriver, output, this.events);
        }
        return this;
    }

    public JavascriptTestExecutor sendXMLHttpRequest(XMLHttpRequest request, ResponseValidator validator) {
        validator.validate(request.send(this.jsExecutor));
        return this;
    }

    public JavascriptTestExecutor refresh() {
        this.jsDriver.navigate().refresh();
        this.configured = false;
        return this;
    }

    public JavascriptTestExecutor addTimeSkew(int addition) {
        this.jsExecutor.executeScript("window.keycloak.timeSkew += " + Integer.toString(addition), new Object[0]);
        return this;
    }

    public JavascriptTestExecutor checkTimeSkew(JavascriptStateValidator validator) {
        Object timeSkew = this.jsExecutor.executeScript("return window.keycloak.timeSkew", new Object[0]);
        validator.validate(this.jsDriver, timeSkew, this.events);
        return this;
    }

    public JavascriptTestExecutor executeScript(String script) {
        return this.executeScript(script, null);
    }

    public JavascriptTestExecutor executeScript(String script, JavascriptStateValidator validator) {
        Object output = this.jsExecutor.executeScript(script, new Object[0]);
        if (validator != null) {
            validator.validate(this.jsDriver, output, this.events);
        }
        return this;
    }

    public boolean isLoggedIn() {
        return (Boolean)this.jsExecutor.executeScript("if (typeof keycloak !== 'undefined') {return keycloak.authenticated} else { return false}", new Object[0]);
    }

    public JavascriptTestExecutor executeAsyncScript(String script) {
        return this.executeAsyncScript(script, null);
    }

    public JavascriptTestExecutor executeAsyncScript(String script, JavascriptStateValidator validator) {
        Object output = this.jsExecutor.executeAsyncScript(script, new Object[0]);
        if (validator != null) {
            validator.validate(this.jsDriver, output, this.events);
        }
        return this;
    }

    public JavascriptTestExecutor errorResponse(JavascriptStateValidator validator) {
        Object output = this.jsExecutor.executeScript("return \"Error: \" + getParameterByName(\"error\") + \"\\n\" + \"Error description: \" + getParameterByName(\"error_description\")", new Object[0]);
        validator.validate(this.jsDriver, output, this.events);
        return this;
    }

    public JavascriptTestExecutor wait(long millis, JavascriptStateValidator validator) {
        WaitUtils.pause(millis);
        if (validator != null) {
            validator.validate(this.jsDriver, null, this.events);
        }
        return this;
    }

    public JavascriptTestExecutor validateOutputField(JavascriptStateValidator validator) {
        validator.validate(this.jsDriver, this.output, this.events);
        return this;
    }
}

