/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.javascript;

import java.util.HashMap;
import java.util.Map;

public class JSObjectBuilder {
    private Map<String, Object> arguments = new HashMap<String, Object>();

    public static JSObjectBuilder create() {
        return new JSObjectBuilder();
    }

    private JSObjectBuilder() {
    }

    public JSObjectBuilder defaultSettings() {
        this.standardFlow();
        this.fragmentResponse();
        this.enableLogging();
        return this;
    }

    public JSObjectBuilder standardFlow() {
        this.arguments.put("flow", "standard");
        return this;
    }

    public JSObjectBuilder implicitFlow() {
        this.arguments.put("flow", "implicit");
        return this;
    }

    public JSObjectBuilder fragmentResponse() {
        this.arguments.put("responseMode", "fragment");
        return this;
    }

    public JSObjectBuilder queryResponse() {
        this.arguments.put("responseMode", "query");
        return this;
    }

    public JSObjectBuilder checkSSOOnLoad() {
        this.arguments.put("onLoad", "check-sso");
        return this;
    }

    public JSObjectBuilder disableSilentCheckSSOFallback() {
        this.arguments.put("silentCheckSsoFallback", false);
        return this;
    }

    public JSObjectBuilder disableCheckLoginIframe() {
        this.arguments.put("checkLoginIframe", false);
        return this;
    }

    public JSObjectBuilder setCheckLoginIframeIntervalTo1() {
        this.arguments.put("checkLoginIframeInterval", 1);
        return this;
    }

    public JSObjectBuilder loginRequiredOnLoad() {
        this.arguments.put("onLoad", "login-required");
        return this;
    }

    public JSObjectBuilder enableLogging() {
        this.arguments.put("enableLogging", true);
        return this;
    }

    public boolean contains(String key, Object value) {
        return this.arguments.containsKey(key) && this.arguments.get(key).equals(value);
    }

    public JSObjectBuilder add(String key, Object value) {
        this.arguments.put(key, value);
        return this;
    }

    public boolean isLoginRequired() {
        return this.arguments.get("onLoad").equals("login-required");
    }

    public JSObjectBuilder pkceS256() {
        return this.pkceMethod("S256");
    }

    private JSObjectBuilder pkceMethod(String method) {
        this.arguments.put("pkceMethod", method);
        return this;
    }

    private boolean skipQuotes(Object o) {
        return o instanceof Integer || o instanceof Boolean;
    }

    public String build() {
        StringBuilder argument = new StringBuilder("{");
        String comma = "";
        for (Map.Entry<String, Object> option : this.arguments.entrySet()) {
            argument.append(comma).append(option.getKey()).append(" : ");
            if (!this.skipQuotes(option.getValue())) {
                argument.append("\"");
            }
            argument.append(option.getValue());
            if (!this.skipQuotes(option.getValue())) {
                argument.append("\"");
            }
            comma = ",";
        }
        argument.append("}");
        return argument.toString();
    }
}

