/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.time.Duration;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.wait.ElementBuilder;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.keycloak.testsuite.util.DroneUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;

public final class WaitUtils {
    protected static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(WaitUtils.class);
    public static final String PAGELOAD_TIMEOUT_PROP = "pageload.timeout";
    public static final Integer PAGELOAD_TIMEOUT_MILLIS = Integer.parseInt(System.getProperty("pageload.timeout", "10000"));
    public static final int IMPLICIT_ELEMENT_WAIT_MILLIS = 1500;

    public static ElementBuilder<Void> waitUntilElement(By by) {
        return Graphene.waitGui().until().element(by);
    }

    public static ElementBuilder<Void> waitUntilElement(WebElement element) {
        return Graphene.waitGui().until().element(element);
    }

    public static ElementBuilder<Void> waitUntilElement(WebElement element, String failMessage) {
        return Graphene.waitGui().until(failMessage).element(element);
    }

    public static void waitUntilElementIsNotPresent(By locator) {
        ((IsElementBuilder)WaitUtils.waitUntilElement(locator).is().not()).present();
    }

    public static void waitUntilElementIsNotPresent(WebElement element) {
        ((IsElementBuilder)WaitUtils.waitUntilElement(element).is().not()).present();
    }

    public static void waitUntilElementClassContains(WebElement element, String value) {
        new WebDriverWait(DroneUtils.getCurrentDriver(), 1L).until((Function)ExpectedConditions.attributeContains((WebElement)element, (String)"class", (String)value));
    }

    public static void pause(long millis) {
        if (millis > 0L) {
            log.info((Object)("Wait: " + millis + "ms"));
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(WaitUtils.class.getName()).log(Level.SEVERE, null, ex);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void waitForDomContentToLoad() {
        WebDriver driver = DroneUtils.getCurrentDriver();
        if (driver instanceof HtmlUnitDriver) {
            return;
        }
        WebDriverWait wait = new WebDriverWait(driver, (long)(PAGELOAD_TIMEOUT_MILLIS / 1000));
        try {
            wait.pollingEvery(Duration.ofMillis(500L)).until((Function)ExpectedConditions.javaScriptThrowsNoExceptions((String)"if (document.readyState !== 'complete') { throw \"Not ready\";}"));
        }
        catch (TimeoutException e) {
            log.warn((Object)"waitForPageToLoad time exceeded!");
        }
    }

    public static void waitForPageToLoad() {
        WebDriver driver = DroneUtils.getCurrentDriver();
        if (driver instanceof HtmlUnitDriver) {
            return;
        }
        String currentUrl = null;
        for (int maxRedirects = 4; maxRedirects > 0; --maxRedirects) {
            currentUrl = driver.getCurrentUrl();
            FluentWait wait = new FluentWait((Object)driver).withTimeout(Duration.ofMillis(250L));
            try {
                wait.until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.urlToBe((String)currentUrl)));
            }
            catch (TimeoutException e) {
                break;
            }
            if (maxRedirects != 1) continue;
            log.warn((Object)"URL seems unstable! (Some redirect are probably still in progress)");
        }
        WebDriverWait wait = new WebDriverWait(DroneUtils.getCurrentDriver(), (long)(PAGELOAD_TIMEOUT_MILLIS / 1000));
        ExpectedCondition waitCondition = null;
        if (currentUrl.matches("^[^\\/]+:\\/\\/[^\\/]+\\/auth\\/admin\\/.*$")) {
            waitCondition = ExpectedConditions.javaScriptThrowsNoExceptions((String)"if (document.readyState !== 'complete' || (typeof angular !== 'undefined' && angular.element(document.body).injector().get('$http').pendingRequests.length !== 0)) {throw \"Not ready\";}");
        } else if (currentUrl.matches("^[^\\/]+:\\/\\/[^\\/]+\\/auth\\/realms\\/[^\\/]+\\/account\\/.*#/.+$")) {
            WaitUtils.pause(2000L);
        }
        if (waitCondition != null) {
            try {
                wait.until((Function)waitCondition);
            }
            catch (TimeoutException e) {
                log.warn((Object)"waitForPageToLoad time exceeded!");
            }
        }
    }

    public static void waitForModalFadeIn() {
        WaitUtils.pause(500L);
    }

    public static void waitForModalFadeOut() {
        WaitUtils.waitUntilElementIsNotPresent(By.className((String)"modal-backdrop"));
    }
}

