/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.keycloak.common.util.Time;
import org.keycloak.testsuite.util.OAuthClient;

public class TokenUtil
implements TestRule {
    private final String username;
    private final String password;
    private OAuthClient oauth;
    private String refreshToken;
    private String token;
    private int expires;

    public TokenUtil() {
        this("test-user@localhost", "password");
    }

    public TokenUtil(String username, String password) {
        this.username = username;
        this.password = password;
        this.oauth = new OAuthClient();
        this.oauth.init(null);
        this.oauth.clientId("direct-grant");
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
            }
        };
    }

    public String getToken() {
        if (this.refreshToken == null) {
            this.load();
        } else if (this.expires < Time.currentTime()) {
            this.refresh();
        }
        return this.token;
    }

    private void load() {
        try {
            OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doGrantAccessTokenRequest("password", this.username, this.password);
            if (accessTokenResponse.getStatusCode() != 200) {
                Assert.fail((String)("Failed to get token: " + accessTokenResponse.getErrorDescription()));
            }
            this.refreshToken = accessTokenResponse.getRefreshToken();
            this.token = accessTokenResponse.getAccessToken();
            this.expires = Time.currentTime() + accessTokenResponse.getExpiresIn() - 20;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void refresh() {
        try {
            OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doRefreshTokenRequest(this.refreshToken, "password");
            if (accessTokenResponse.getStatusCode() != 200) {
                Assert.fail((String)("Failed to get token: " + accessTokenResponse.getErrorDescription()));
            }
            this.refreshToken = accessTokenResponse.getRefreshToken();
            this.token = accessTokenResponse.getAccessToken();
            this.expires = Time.currentTime() + accessTokenResponse.getExpiresIn() - 20;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

