/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.jboss.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.keycloak.testsuite.utils.io.IOUtil;

public class Timer {
    public static final Timer DEFAULT = new Timer();
    protected final Logger log = Logger.getLogger(Timer.class);
    protected static final File DATA_DIR = new File(IOUtil.PROJECT_BUILD_DIRECTORY, "stats/data");
    protected static final File CHARTS_DIR = new File(IOUtil.PROJECT_BUILD_DIRECTORY, "stats/charts");
    public static final String DEFAULT_OPERATION = "DEFAULT_OPERATION";
    private Long time;
    private String operation = "DEFAULT_OPERATION";
    private final Map<String, List<Long>> stats = new TreeMap<String, List<Long>>();

    public long elapsedTime() {
        long elapsedTime = 0L;
        if (this.time != null) {
            elapsedTime = new Date().getTime() - this.time;
        }
        return elapsedTime;
    }

    public void reset() {
        this.reset(this.operation);
    }

    public void reset(String operation) {
        this.reset(operation, true);
    }

    public void reset(String newOperation, boolean logOperationOnChange) {
        if (this.time != null && (this.operation.equals(newOperation) || logOperationOnChange)) {
            this.logOperation(this.operation, this.elapsedTime());
        }
        this.time = new Date().getTime();
        if (!this.operation.equals(newOperation)) {
            this.operation = newOperation;
            this.log.info((Object)String.format("Operation '%s' started.", newOperation));
        }
    }

    private void logOperation(String operation, long duration) {
        if (!this.stats.containsKey(operation)) {
            this.stats.put(operation, new ArrayList());
        }
        this.stats.get(operation).add(duration);
        this.log.info((Object)String.format("Operation '%s' took: %s ms", operation, duration));
    }

    public void clearStats() {
        this.clearStats(true, true, true);
    }

    public void clearStats(boolean logStats, boolean saveData, boolean saveCharts) {
        if (logStats) {
            this.log.info((Object)"Timer Statistics:");
            for (String op : this.stats.keySet()) {
                long sum = 0L;
                for (Long duration : this.stats.get(op)) {
                    sum += duration.longValue();
                }
                this.log.info((Object)String.format("Operation '%s' average: %s ms", op, sum / (long)this.stats.get(op).size()));
            }
        }
        if (IOUtil.PROJECT_BUILD_DIRECTORY.exists()) {
            DATA_DIR.mkdirs();
            CHARTS_DIR.mkdirs();
            for (String op : this.stats.keySet()) {
                if (saveData) {
                    this.saveData(op);
                }
                if (!saveCharts) continue;
                this.saveChart(op);
            }
        }
        this.stats.clear();
    }

    private void saveData(String op) {
        try {
            File f = new File(DATA_DIR, op.replace(" ", "_") + ".txt");
            if (!f.createNewFile()) {
                throw new IOException("Couldn't create file: " + f);
            }
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(f));
            for (Long duration : this.stats.get(op)) {
                IOUtils.write((String)duration.toString(), (OutputStream)stream, (String)"UTF-8");
                IOUtils.write((String)"\n", (OutputStream)stream, (String)"UTF-8");
            }
            ((OutputStream)stream).flush();
            IOUtils.closeQuietly((OutputStream)stream);
        }
        catch (IOException ex) {
            this.log.error((Object)("Unable to save data for operation '" + op + "'"), (Throwable)ex);
        }
    }

    private void saveChart(String op) {
        XYSeries series = new XYSeries((Comparable)((Object)op));
        int i = 0;
        for (Long duration : this.stats.get(op)) {
            series.add((double)(++i), (Number)duration);
        }
        XYSeriesCollection data = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)op, (String)"Operations", (String)"Duration (ms)", (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        try {
            ChartUtilities.saveChartAsPNG((File)new File(CHARTS_DIR, op.replace(" ", "_") + ".png"), (JFreeChart)chart, (int)640, (int)480);
        }
        catch (IOException ex) {
            this.log.warn((Object)("Unable to save chart for operation '" + op + "'."));
        }
    }
}

