/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.ws.rs.NotFoundException;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.ConcurrentMultivaluedHashMap;
import org.keycloak.testsuite.arquillian.TestContext;

public class TestCleanup {
    private static final String IDENTITY_PROVIDER_ALIASES = "IDENTITY_PROVIDER_ALIASES";
    private static final String USER_IDS = "USER_IDS";
    private static final String COMPONENT_IDS = "COMPONENT_IDS";
    private static final String CLIENT_UUIDS = "CLIENT_UUIDS";
    private static final String CLIENT_SCOPE_IDS = "CLIENT_SCOPE_IDS";
    private static final String ROLE_IDS = "ROLE_IDS";
    private static final String GROUP_IDS = "GROUP_IDS";
    private static final String AUTH_FLOW_IDS = "AUTH_FLOW_IDS";
    private static final String AUTH_CONFIG_IDS = "AUTH_CONFIG_IDS";
    private static final String LOCALIZATION_LANGUAGES = "LOCALIZATION_LANGUAGES";
    private final TestContext testContext;
    private final String realmName;
    private final ConcurrentLinkedDeque<Runnable> genericCleanups = new ConcurrentLinkedDeque();
    private final ConcurrentMultivaluedHashMap<String, String> entities = new ConcurrentMultivaluedHashMap();

    public TestCleanup(TestContext testContext, String realmName) {
        this.testContext = testContext;
        this.realmName = realmName;
    }

    public TestCleanup addCleanup(Runnable r) {
        this.genericCleanups.add(r);
        return this;
    }

    public TestCleanup addCleanup(AutoCloseable c) {
        this.genericCleanups.add(() -> {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return this;
    }

    public void addUserId(String userId) {
        this.entities.add((Object)USER_IDS, (Object)userId);
    }

    public void addIdentityProviderAlias(String identityProviderAlias) {
        this.entities.add((Object)IDENTITY_PROVIDER_ALIASES, (Object)identityProviderAlias);
    }

    public void addComponentId(String componentId) {
        this.entities.add((Object)COMPONENT_IDS, (Object)componentId);
    }

    public void addClientUuid(String clientUuid) {
        this.entities.add((Object)CLIENT_UUIDS, (Object)clientUuid);
    }

    public void addClientScopeId(String clientScopeId) {
        this.entities.add((Object)CLIENT_SCOPE_IDS, (Object)clientScopeId);
    }

    public void addRoleId(String roleId) {
        this.entities.add((Object)ROLE_IDS, (Object)roleId);
    }

    public void addGroupId(String groupId) {
        this.entities.add((Object)GROUP_IDS, (Object)groupId);
    }

    public void addAuthenticationFlowId(String flowId) {
        this.entities.add((Object)AUTH_FLOW_IDS, (Object)flowId);
    }

    public void addLocalization(String language) {
        this.entities.add((Object)LOCALIZATION_LANGUAGES, (Object)language);
    }

    public void addAuthenticationConfigId(String executionConfigId) {
        this.entities.add((Object)AUTH_CONFIG_IDS, (Object)executionConfigId);
    }

    public void executeCleanup() {
        List localizationLanguages;
        List authConfigIds;
        List authFlowIds;
        List groupIds;
        List roleIds;
        List clientScopeIds;
        List clientUuids;
        List componentIds;
        List identityProviderAliases;
        RealmResource realm = this.getAdminClient().realm(this.realmName);
        Streams.stream(this.genericCleanups.descendingIterator()).forEach(Runnable::run);
        List userIds = (List)this.entities.get((Object)USER_IDS);
        if (userIds != null) {
            for (Object userId : userIds) {
                try {
                    realm.users().get((String)userId).remove();
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((identityProviderAliases = (List)this.entities.get((Object)IDENTITY_PROVIDER_ALIASES)) != null) {
            for (Object idpAlias : identityProviderAliases) {
                try {
                    realm.identityProviders().get((String)idpAlias).remove();
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((componentIds = (List)this.entities.get((Object)COMPONENT_IDS)) != null) {
            for (Object componentId : componentIds) {
                try {
                    realm.components().component((String)componentId).remove();
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((clientUuids = (List)this.entities.get((Object)CLIENT_UUIDS)) != null) {
            for (Object clientUuId : clientUuids) {
                try {
                    realm.clients().get((String)clientUuId).remove();
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((clientScopeIds = (List)this.entities.get((Object)CLIENT_SCOPE_IDS)) != null) {
            for (Object clientScopeId : clientScopeIds) {
                try {
                    realm.clientScopes().get((String)clientScopeId).remove();
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((roleIds = (List)this.entities.get((Object)ROLE_IDS)) != null) {
            for (Object roleId : roleIds) {
                try {
                    realm.rolesById().deleteRole((String)roleId);
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((groupIds = (List)this.entities.get((Object)GROUP_IDS)) != null) {
            for (Object groupId : groupIds) {
                try {
                    realm.groups().group((String)groupId).remove();
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((authFlowIds = (List)this.entities.get((Object)AUTH_FLOW_IDS)) != null) {
            for (Object flowId : authFlowIds) {
                try {
                    realm.flows().deleteFlow((String)flowId);
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((authConfigIds = (List)this.entities.get((Object)AUTH_CONFIG_IDS)) != null) {
            for (String configId : authConfigIds) {
                try {
                    realm.flows().removeAuthenticatorConfig(configId);
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        if ((localizationLanguages = (List)this.entities.get((Object)LOCALIZATION_LANGUAGES)) != null) {
            for (String localizationLanguage : localizationLanguages) {
                try {
                    realm.localization().deleteRealmLocalizationTexts(localizationLanguage);
                }
                catch (NotFoundException notFoundException) {}
            }
        }
    }

    private Keycloak getAdminClient() {
        return this.testContext.getAdminClient();
    }
}

