/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;

public class SystemInfoHelper {
    public static String getSystemInfo() {
        Runtime runtime = Runtime.getRuntime();
        StringBuilder s = new StringBuilder("TEST PROCESS INFO: ");
        s.append("\nAvailable processors: " + runtime.availableProcessors());
        s.append("\nTotal memory: " + SystemInfoHelper.toMB(runtime.totalMemory()));
        s.append("\nMax memory (Xmx): " + SystemInfoHelper.toMB(runtime.maxMemory()));
        for (MemoryPoolMXBean memoryMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!"Metaspace".equalsIgnoreCase(memoryMXBean.getName())) continue;
            s.append("\nMetaspace Max: " + SystemInfoHelper.toMB(memoryMXBean.getUsage().getMax()));
        }
        return s.toString();
    }

    private static String toMB(long bytes) {
        return bytes / 1024L / 1024L + " MB";
    }
}

