/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.logging.Logger;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.arquillian.SuiteContext;
import org.keycloak.testsuite.arquillian.annotation.SetDefaultProvider;
import org.keycloak.testsuite.arquillian.containers.KeycloakQuarkusServerDeployableContainer;
import org.keycloak.utils.StringUtil;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;

public class SpiProvidersSwitchingUtils {
    private static final String SUBSYSTEM_KEYCLOAK_SERVER_SPI = "/subsystem=keycloak-server/spi=";
    private static final String KEYCLOAKX_ARG_SPI_PREFIX = "--spi-";
    private static final Map<String, String> originalSettingsBackup = new ConcurrentHashMap<String, String>();
    protected static final Logger log = Logger.getLogger(SpiProvidersSwitchingUtils.class);

    private SpiProvidersSwitchingUtils() {
    }

    public static void addProviderDefaultValue(SuiteContext suiteContext, SetDefaultProvider annotation) {
        ContainerInfo authServerInfo = suiteContext.getAuthServerInfo();
        SpiSwitcher spiSwitcher = SpiSwitcher.getSpiSwitcherFor(authServerInfo);
        String spi = annotation.spi();
        Container container = authServerInfo.getArquillianContainer();
        log.infof("Setting default provider for %s to %s", (Object)spi, (Object)annotation.providerId());
        if (annotation.onlyUpdateDefault()) {
            spiSwitcher.getCurrentDefaultProvider(container, spi, annotation).ifPresent(v -> originalSettingsBackup.put(spi, (String)v));
            spiSwitcher.updateDefaultProvider(container, spi, annotation.providerId());
        } else {
            spiSwitcher.setDefaultProvider(container, spi, annotation.providerId());
        }
    }

    public static void resetProvider(SuiteContext suiteContext, SetDefaultProvider annotation) {
        ContainerInfo authServerInfo = suiteContext.getAuthServerInfo();
        SpiSwitcher spiSwitcher = SpiSwitcher.getSpiSwitcherFor(authServerInfo);
        String spi = annotation.spi();
        Container container = authServerInfo.getArquillianContainer();
        if (annotation.onlyUpdateDefault()) {
            String originalValue = originalSettingsBackup.get(spi);
            log.infof("Resetting default provider for %s to %s", (Object)spi, (Object)(originalValue == null ? "<null>" : originalValue));
            if (originalValue != null) {
                spiSwitcher.updateDefaultProvider(container, spi, originalValue);
            } else {
                spiSwitcher.unsetDefaultProvider(container, spi);
            }
        } else {
            log.infof("Removing default provider for %s to %s", (Object)spi);
            spiSwitcher.removeProviderConfig(container, spi);
        }
    }

    public static void removeProvider(SuiteContext suiteContext, SetDefaultProvider annotation) {
        ContainerInfo authServerInfo = suiteContext.getAuthServerInfo();
        SpiSwitcher spiSwitcher = SpiSwitcher.getSpiSwitcherFor(authServerInfo);
        String spi = annotation.spi();
        Container container = authServerInfo.getArquillianContainer();
        log.infof("Removing default provider setting for %s", (Object)spi);
        if (annotation.onlyUpdateDefault()) {
            spiSwitcher.unsetDefaultProvider(container, spi);
        } else {
            spiSwitcher.removeProviderConfig(container, spi);
        }
    }

    private static enum SpiSwitcher {
        UNDERTOW{

            @Override
            public Optional<String> getCurrentDefaultProvider(Container container, String spiName, SetDefaultProvider annotation) {
                return Optional.ofNullable(System.getProperty(this.getProviderPropertyName(spiName)));
            }

            @Override
            public void setDefaultProvider(Container container, String spiName, String providerId) {
                System.setProperty(this.getProviderPropertyName(spiName), providerId);
            }

            @Override
            public void removeProviderConfig(Container container, String spiName) {
                System.clearProperty(this.getProviderPropertyName(spiName));
            }

            private String getProviderPropertyName(String spiName) {
                return "keycloak." + spiName + ".provider";
            }
        }
        ,
        WILDFLY{

            @Override
            public Optional<String> getCurrentDefaultProvider(Container container, String spiName, SetDefaultProvider annotation) {
                String cliCmd = SpiProvidersSwitchingUtils.SUBSYSTEM_KEYCLOAK_SERVER_SPI + spiName + ":read-attribute(name=default-provider)";
                return this.runInCli(cliCmd).filter(ModelNodeResult::isSuccess).map(n -> n.get("result").asString());
            }

            @Override
            public void setDefaultProvider(Container container, String spiName, String providerId) {
                this.runInCli(SpiProvidersSwitchingUtils.SUBSYSTEM_KEYCLOAK_SERVER_SPI + spiName + "/:add(default-provider=\"" + providerId + "\")");
            }

            @Override
            public void updateDefaultProvider(Container container, String spiName, String providerId) {
                this.runInCli(SpiProvidersSwitchingUtils.SUBSYSTEM_KEYCLOAK_SERVER_SPI + spiName + ":write-attribute(name=default-provider, value=" + providerId + ")");
            }

            @Override
            public void unsetDefaultProvider(Container container, String spiName) {
                this.runInCli(SpiProvidersSwitchingUtils.SUBSYSTEM_KEYCLOAK_SERVER_SPI + spiName + ":/:undefine-attribute(name=default-provider)");
            }

            @Override
            public void removeProviderConfig(Container container, String spiName) {
                this.runInCli(SpiProvidersSwitchingUtils.SUBSYSTEM_KEYCLOAK_SERVER_SPI + spiName + "/:remove");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Optional<ModelNodeResult> runInCli(String cliCmd) {
                try (OnlineManagementClient client = AuthServerTestEnricher.getManagementClient();){
                    Optional<ModelNodeResult> optional = Optional.ofNullable(client.execute(cliCmd));
                    return optional;
                }
                catch (IOException | CliException throwable6) {
                    return Optional.empty();
                }
            }
        }
        ,
        QUARKUS{

            @Override
            public void setDefaultProvider(Container container, String spiName, String providerId) {
                this.getQuarkusContainer(container).setAdditionalBuildArgs(Collections.singletonList(SpiProvidersSwitchingUtils.KEYCLOAKX_ARG_SPI_PREFIX + this.toDashCase(spiName) + "-provider=" + providerId));
            }

            @Override
            public void removeProviderConfig(Container container, String spiName) {
                this.getQuarkusContainer(container).setAdditionalBuildArgs(Collections.emptyList());
            }

            private KeycloakQuarkusServerDeployableContainer getQuarkusContainer(Container container) {
                return (KeycloakQuarkusServerDeployableContainer)container.getDeployableContainer();
            }

            private String toDashCase(String s) {
                StringBuilder sb = new StringBuilder(s.length());
                boolean l = false;
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (l && Character.isUpperCase(c)) {
                        sb.append('-');
                        c = Character.toLowerCase(c);
                        l = false;
                    } else {
                        l = Character.isLowerCase(c);
                    }
                    sb.append(c);
                }
                return sb.toString();
            }
        };


        public Optional<String> getCurrentDefaultProvider(Container container, String spiName, SetDefaultProvider annotation) {
            String defaultProvider = annotation.defaultProvider();
            if (StringUtil.isNotBlank((String)defaultProvider)) {
                return Optional.of(defaultProvider);
            }
            return Optional.empty();
        }

        public abstract void setDefaultProvider(Container var1, String var2, String var3);

        public void updateDefaultProvider(Container container, String spiName, String providerId) {
            this.setDefaultProvider(container, spiName, providerId);
        }

        public void unsetDefaultProvider(Container container, String spiName) {
            this.removeProviderConfig(container, spiName);
        }

        public abstract void removeProviderConfig(Container var1, String var2);

        public static SpiSwitcher getSpiSwitcherFor(ContainerInfo containerInfo) {
            if (containerInfo.isUndertow()) {
                return UNDERTOW;
            }
            if (containerInfo.isQuarkus()) {
                return QUARKUS;
            }
            return WILDFLY;
        }
    }
}

