/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.InputStream;
import org.apache.tools.ant.filters.StringInputStream;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.config.parsers.DeploymentBuilder;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.testsuite.utils.arquillian.DeploymentArchiveProcessorUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.w3c.dom.Document;

public class SamlUtils {
    public static SamlDeployment getSamlDeploymentForClient(final String client) throws ParsingException {
        InputStream is = SamlUtils.class.getResourceAsStream("/adapter-test/keycloak-saml/" + client + "/WEB-INF/keycloak-saml.xml");
        Document doc = IOUtil.loadXML((InputStream)is);
        DeploymentArchiveProcessorUtils.modifySAMLDocument((Document)doc);
        InputStream isProcessed = IOUtil.documentToInputStream((Document)doc);
        ResourceLoader loader = new ResourceLoader(){

            public InputStream getResourceAsStream(String resource) {
                return this.getClass().getResourceAsStream("/adapter-test/keycloak-saml/" + client + resource);
            }
        };
        return new DeploymentBuilder().build(isProcessed, loader);
    }

    public static SPSSODescriptorType getSPInstallationDescriptor(ClientsResource res, String clientId) throws ParsingException {
        String spDescriptorString = res.findByClientId(clientId).stream().findFirst().map(ClientRepresentation::getId).map(arg_0 -> ((ClientsResource)res).get(arg_0)).map(clientResource -> clientResource.getInstallationProvider("saml-sp-descriptor")).orElseThrow(() -> new RuntimeException("Missing descriptor"));
        SAMLParser parser = SAMLParser.getInstance();
        EntityDescriptorType o = (EntityDescriptorType)parser.parse((InputStream)new StringInputStream(spDescriptorString));
        return ((EntityDescriptorType.EDTDescriptorChoiceType)((EntityDescriptorType.EDTChoiceType)o.getChoiceType().get(0)).getDescriptors().get(0)).getSpDescriptor();
    }
}

