/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.saml.CreateArtifactMessageStepBuilder;
import org.keycloak.testsuite.util.saml.CreateAuthnRequestStepBuilder;
import org.keycloak.testsuite.util.saml.CreateLogoutRequestStepBuilder;
import org.keycloak.testsuite.util.saml.HandleArtifactStepBuilder;
import org.keycloak.testsuite.util.saml.IdPInitiatedLoginBuilder;
import org.keycloak.testsuite.util.saml.LoginBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.keycloak.testsuite.util.saml.RequiredConsentBuilder;
import org.keycloak.testsuite.util.saml.SamlDocumentStepBuilder;
import org.keycloak.testsuite.util.saml.UpdateProfileBuilder;
import org.w3c.dom.Document;

public class SamlClientBuilder {
    private final List<SamlClient.Step> steps = new LinkedList<SamlClient.Step>();

    public SamlClient execute() {
        return this.execute(resp -> {});
    }

    public SamlClient execute(Consumer<CloseableHttpResponse> resultConsumer) {
        SamlClient samlClient = this.createSamlClient();
        samlClient.executeAndTransform(r -> {
            resultConsumer.accept(r);
            return null;
        }, this.steps);
        return samlClient;
    }

    protected SamlClient createSamlClient() {
        return new SamlClient();
    }

    public <T> T executeAndTransform(SamlClient.ResultExtractor<T> resultTransformer) {
        return this.createSamlClient().executeAndTransform(resultTransformer, this.steps);
    }

    public List<SamlClient.Step> getSteps() {
        return this.steps;
    }

    public <T extends SamlClient.Step> T addStepBuilder(T step) {
        this.steps.add(step);
        return step;
    }

    public SamlClientBuilder addStep(SamlClient.Step step) {
        this.steps.add(step);
        return this;
    }

    public SamlClientBuilder addStep(Runnable stepWithNoParameters) {
        this.addStep((CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) -> {
            stepWithNoParameters.run();
            return null;
        });
        return this;
    }

    public <T> T andThen(Function<SamlClientBuilder, T> next) {
        return next.apply(this);
    }

    public SamlClientBuilder assertResponse(Matcher<? super CloseableHttpResponse> matcher) {
        this.steps.add((client, currentURI, currentResponse, context) -> {
            Assert.assertThat((Object)currentResponse, (Matcher)matcher);
            return null;
        });
        return this;
    }

    public SamlClientBuilder assertResponse(Consumer<? super CloseableHttpResponse> consumer) {
        this.steps.add((client, currentURI, currentResponse, context) -> {
            consumer.accept(currentResponse);
            return null;
        });
        return this;
    }

    public SamlClientBuilder doNotFollowRedirects() {
        this.steps.add(new SamlClient.DoNotFollowRedirectStep());
        return this;
    }

    public SamlClientBuilder clearCookies() {
        this.steps.add((client, currentURI, currentResponse, context) -> {
            context.getCookieStore().clear();
            return null;
        });
        return this;
    }

    public CreateAuthnRequestStepBuilder authnRequest(URI authServerSamlUrl, String issuer, String assertionConsumerURL, SamlClient.Binding requestBinding) {
        return this.addStepBuilder(new CreateAuthnRequestStepBuilder(authServerSamlUrl, issuer, assertionConsumerURL, requestBinding, this));
    }

    public CreateAuthnRequestStepBuilder authnRequest(URI authServerSamlUrl, Document authnRequestDocument, SamlClient.Binding requestBinding) {
        return this.addStepBuilder(new CreateAuthnRequestStepBuilder(authServerSamlUrl, authnRequestDocument, requestBinding, this));
    }

    public CreateLogoutRequestStepBuilder logoutRequest(URI authServerSamlUrl, String issuer, SamlClient.Binding requestBinding) {
        return this.addStepBuilder(new CreateLogoutRequestStepBuilder(authServerSamlUrl, issuer, requestBinding, this));
    }

    public ModifySamlResponseStepBuilder submitSamlDocument(URI authServerSamlUrl, String samlDocument, SamlClient.Binding binding) {
        return this.addStepBuilder(new ModifySamlResponseStepBuilder(binding, this).targetUri(authServerSamlUrl).documentSupplier(() -> samlDocument));
    }

    public ModifySamlResponseStepBuilder submitSamlDocument(URI authServerSamlUrl, SAML2Object samlObject, SamlClient.Binding binding) {
        return this.addStepBuilder(new ModifySamlResponseStepBuilder(binding, this).targetUri(authServerSamlUrl).documentSupplier(() -> SamlDocumentStepBuilder.saml2Object2String(samlObject)));
    }

    public LoginBuilder login() {
        return this.addStepBuilder(new LoginBuilder(this));
    }

    public UpdateProfileBuilder updateProfile() {
        return this.addStepBuilder(new UpdateProfileBuilder(this));
    }

    public IdPInitiatedLoginBuilder idpInitiatedLogin(URI authServerSamlUrl, String clientId) {
        return this.addStepBuilder(new IdPInitiatedLoginBuilder(authServerSamlUrl, clientId, this));
    }

    public RequiredConsentBuilder consentRequired() {
        return this.addStepBuilder(new RequiredConsentBuilder(this));
    }

    public SAMLDocumentHolder getSamlResponse(SamlClient.Binding responseBinding) {
        return this.doNotFollowRedirects().executeAndTransform(responseBinding::extractResponse);
    }

    public String getSamlRelayState(SamlClient.Binding responseBinding) {
        return this.doNotFollowRedirects().executeAndTransform(responseBinding::extractRelayState);
    }

    public SamlClientBuilder assertSamlRelayState(SamlClient.Binding responseBinding, Consumer<String> relayStateConsumer) {
        if (responseBinding.equals((Object)SamlClient.Binding.REDIRECT)) {
            this.doNotFollowRedirects();
        }
        return this.addStep((CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) -> {
            relayStateConsumer.accept(responseBinding.extractRelayState(currentResponse));
            return null;
        });
    }

    public ModifySamlResponseStepBuilder processSamlResponse(SamlClient.Binding responseBinding) {
        return this.doNotFollowRedirects().addStepBuilder(new ModifySamlResponseStepBuilder(responseBinding, this));
    }

    public SamlClientBuilder navigateTo(String httpGetUri) {
        this.steps.add((client, currentURI, currentResponse, context) -> new HttpGet(httpGetUri));
        return this;
    }

    public SamlClientBuilder navigateTo(AbstractPage page) {
        return this.navigateTo(page.buildUri());
    }

    public SamlClientBuilder navigateTo(URI httpGetUri) {
        this.steps.add((client, currentURI, currentResponse, context) -> new HttpGet(httpGetUri));
        return this;
    }

    public SamlClientBuilder followOneRedirect() {
        return this.doNotFollowRedirects().addStep((CloseableHttpClient client, URI currentURI, CloseableHttpResponse currentResponse, HttpClientContext context) -> {
            Assert.assertThat((Object)currentResponse, Matchers.statusCodeIsHC(Response.Status.FOUND));
            Assert.assertThat((String)"Location header not found", (Object)currentResponse.getFirstHeader("Location"), (Matcher)org.hamcrest.Matchers.notNullValue());
            return new HttpGet(currentResponse.getFirstHeader("Location").getValue());
        });
    }

    public HandleArtifactStepBuilder handleArtifact(URI authServerSamlUrl, String issuer) {
        return this.doNotFollowRedirects().addStepBuilder(new HandleArtifactStepBuilder(authServerSamlUrl, issuer, this));
    }

    public HandleArtifactStepBuilder handleArtifact(HandleArtifactStepBuilder handleArtifactStepBuilder) {
        return this.doNotFollowRedirects().addStepBuilder(handleArtifactStepBuilder);
    }

    public CreateArtifactMessageStepBuilder artifactMessage(URI authServerSamlUrl, String issuer, SamlClient.Binding requestBinding) {
        return this.addStepBuilder(new CreateArtifactMessageStepBuilder(authServerSamlUrl, issuer, requestBinding, this));
    }

    public CreateArtifactMessageStepBuilder artifactMessage(CreateArtifactMessageStepBuilder camb) {
        return this.addStepBuilder(camb);
    }
}

