/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.jboss.arquillian.drone.webdriver.htmlunit.DroneHtmlUnitDriver;
import org.junit.Assert;
import org.keycloak.TokenVerifier;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.AsymmetricSignatureVerifierContext;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerECDSASignatureSignerContext;
import org.keycloak.crypto.ServerECDSASignatureVerifierContext;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.grants.ciba.CibaGrantType;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelResponse;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.protocol.oidc.par.endpoints.ParEndpoint;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AuthorizationResponseToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.UserInfo;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.runonserver.RunOnServerException;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class OAuthClient {
    public static String SERVER_ROOT;
    public static String AUTH_SERVER_ROOT;
    public static String APP_ROOT;
    public static String APP_AUTH_ROOT;
    private static final boolean sslRequired;
    private WebDriver driver;
    private String baseUrl = AUTH_SERVER_ROOT;
    private String realm;
    private String clientId;
    private String redirectUri;
    private String kcAction;
    private StateParamProvider state;
    private String scope;
    private String uiLocales;
    private String clientSessionState;
    private String clientSessionHost;
    private String maxAge;
    private String responseType;
    private String responseMode;
    private String nonce;
    private String request;
    private String requestUri;
    private Map<String, String> requestHeaders;
    private Map<String, JSONWebKeySet> publicKeys = new HashMap<String, JSONWebKeySet>();
    private String codeVerifier;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String origin;
    private Map<String, String> customParameters;
    private boolean openid = true;
    private Supplier<CloseableHttpClient> httpClient = OAuthClient::newCloseableHttpClient;

    public static void updateURLs(String serverRoot) {
        SERVER_ROOT = ServerURLs.removeDefaultPorts((String)serverRoot);
        AUTH_SERVER_ROOT = SERVER_ROOT + "/auth";
        OAuthClient.updateAppRootRealm("master");
    }

    public static void updateAppRootRealm(String realm) {
        APP_ROOT = AUTH_SERVER_ROOT + "/realms/" + realm + "/app";
        APP_AUTH_ROOT = APP_ROOT + "/auth";
    }

    public static void resetAppRootRealm() {
        OAuthClient.updateAppRootRealm("master");
    }

    public void init(WebDriver driver) {
        this.driver = driver;
        this.baseUrl = AUTH_SERVER_ROOT;
        this.realm = "test";
        this.clientId = "test-app";
        this.redirectUri = APP_ROOT + "/auth";
        this.state = () -> KeycloakModelUtils.generateId();
        this.scope = null;
        this.uiLocales = null;
        this.clientSessionState = null;
        this.clientSessionHost = null;
        this.maxAge = null;
        this.responseType = "code";
        this.responseMode = null;
        this.nonce = null;
        this.request = null;
        this.requestUri = null;
        this.codeVerifier = null;
        this.codeChallenge = null;
        this.codeChallengeMethod = null;
        this.origin = null;
        this.customParameters = null;
        this.openid = true;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public AuthorizationEndpointResponse doLogin(String username, String password) {
        this.openLoginForm();
        this.fillLoginForm(username, password);
        return new AuthorizationEndpointResponse(this);
    }

    public AuthorizationEndpointResponse doLoginSocial(String brokerId, String username, String password) {
        this.openLoginForm();
        WaitUtils.waitForPageToLoad();
        WebElement socialButton = this.findSocialButton(brokerId);
        UIUtils.clickLink(socialButton);
        this.fillLoginForm(username, password);
        return new AuthorizationEndpointResponse(this);
    }

    public void updateAccountInformation(String username, String email) {
        WaitUtils.waitForPageToLoad();
        this.updateAccountInformation(username, email, "First", "Last");
    }

    public void linkUsers(String username, String password) {
        WaitUtils.waitForPageToLoad();
        WebElement linkAccountButton = this.driver.findElement(By.id((String)"linkAccount"));
        WaitUtils.waitUntilElement(linkAccountButton).is().clickable();
        linkAccountButton.click();
        WaitUtils.waitForPageToLoad();
        WebElement usernameInput = this.driver.findElement(By.id((String)"username"));
        usernameInput.clear();
        usernameInput.sendKeys(new CharSequence[]{username});
        WebElement passwordInput = this.driver.findElement(By.id((String)"password"));
        passwordInput.clear();
        passwordInput.sendKeys(new CharSequence[]{password});
        WebElement loginButton = this.driver.findElement(By.id((String)"kc-login"));
        WaitUtils.waitUntilElement(loginButton).is().clickable();
        loginButton.click();
    }

    public AuthorizationEndpointResponse doLogin(UserRepresentation user) {
        return this.doLogin(user.getUsername(), Users.getPasswordOf(user));
    }

    public AuthorizationEndpointResponse doRememberMeLogin(String username, String password) {
        this.openLoginForm();
        this.fillLoginForm(username, password, true);
        return new AuthorizationEndpointResponse(this);
    }

    public void fillLoginForm(String username, String password) {
        this.fillLoginForm(username, password, false);
    }

    public void fillLoginForm(String username, String password, boolean rememberMe) {
        WaitUtils.waitForPageToLoad();
        String src = this.driver.getPageSource();
        try {
            this.driver.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{username});
            this.driver.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{password});
            if (rememberMe) {
                this.driver.findElement(By.id((String)"rememberMe")).click();
            }
            this.driver.findElement(By.name((String)"login")).click();
        }
        catch (Throwable t) {
            System.err.println(src);
            throw t;
        }
    }

    private void updateAccountInformation(String username, String email, String firstName, String lastName) {
        WebElement usernameInput = this.driver.findElement(By.id((String)"username"));
        usernameInput.clear();
        usernameInput.sendKeys(new CharSequence[]{username});
        WebElement emailInput = this.driver.findElement(By.id((String)"email"));
        emailInput.clear();
        emailInput.sendKeys(new CharSequence[]{email});
        WebElement firstNameInput = this.driver.findElement(By.id((String)"firstName"));
        firstNameInput.clear();
        firstNameInput.sendKeys(new CharSequence[]{firstName});
        WebElement lastNameInput = this.driver.findElement(By.id((String)"lastName"));
        lastNameInput.clear();
        lastNameInput.sendKeys(new CharSequence[]{lastName});
        WebElement submitButton = this.driver.findElement(By.cssSelector((String)"input[type=\"submit\"]"));
        WaitUtils.waitUntilElement(submitButton).is().clickable();
        submitButton.click();
    }

    public void doLoginGrant(String username, String password) {
        this.openLoginForm();
        this.fillLoginForm(username, password);
    }

    public OAuthClient httpClient(Supplier<CloseableHttpClient> client) {
        this.httpClient = client;
        return this;
    }

    public Supplier<CloseableHttpClient> getHttpClient() {
        return this.httpClient;
    }

    public static CloseableHttpClient newCloseableHttpClient() {
        if (sslRequired) {
            String keyStorePath = System.getProperty("client.certificate.keystore");
            String keyStorePassword = System.getProperty("client.certificate.keystore.passphrase");
            String trustStorePath = System.getProperty("client.truststore");
            String trustStorePassword = System.getProperty("client.truststore.passphrase");
            return OAuthClient.newCloseableHttpClientSSL(keyStorePath, keyStorePassword, trustStorePath, trustStorePassword);
        }
        return org.apache.http.impl.client.HttpClientBuilder.create().build();
    }

    public static CloseableHttpClient newCloseableHttpClientSSL(String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword) {
        KeyStore keystore = null;
        try {
            keystore = KeystoreUtil.loadKeyStore((String)keyStorePath, (String)keyStorePassword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        KeyStore truststore = null;
        try {
            truststore = KeystoreUtil.loadKeyStore((String)trustStorePath, (String)trustStorePassword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (CloseableHttpClient)new HttpClientBuilder().keyStore(keystore, keyStorePassword).trustStore(truststore).hostnameVerification(HttpClientBuilder.HostnameVerificationPolicy.ANY).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CloseableHttpResponse doPreflightRequest() {
        try (CloseableHttpClient client = this.httpClient.get();){
            HttpOptions options = new HttpOptions(this.getAccessTokenUrl());
            options.setHeader("Origin", "http://example.com");
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)options);
            return closeableHttpResponse;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessTokenResponse doAccessTokenRequest(String code, String password) {
        try (CloseableHttpClient client = this.httpClient.get();){
            AccessTokenResponse accessTokenResponse = this.doAccessTokenRequest(code, password, client);
            return accessTokenResponse;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public AccessTokenResponse doAccessTokenRequest(String code, String password, CloseableHttpClient client) {
        HttpPost post = new HttpPost(this.getAccessTokenUrl());
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "authorization_code"));
        if (this.origin != null) {
            post.addHeader("Origin", this.origin);
        }
        if (code != null) {
            parameters.add(new BasicNameValuePair("code", code));
        }
        if (this.redirectUri != null) {
            parameters.add(new BasicNameValuePair("redirect_uri", this.redirectUri));
        }
        if (this.clientId != null && password != null) {
            String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)password);
            post.setHeader("Authorization", authorization);
        } else if (this.clientId != null) {
            parameters.add(new BasicNameValuePair("client_id", this.clientId));
        }
        if (this.clientSessionState != null) {
            parameters.add(new BasicNameValuePair("client_session_state", this.clientSessionState));
        }
        if (this.clientSessionHost != null) {
            parameters.add(new BasicNameValuePair("client_session_host", this.clientSessionHost));
        }
        if (this.codeVerifier != null) {
            parameters.add(new BasicNameValuePair("code_verifier", this.codeVerifier));
        }
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, Charsets.UTF_8);
        post.setEntity((HttpEntity)formEntity);
        try {
            return new AccessTokenResponse(client.execute((HttpUriRequest)post));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve access token", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String introspectTokenWithClientCredential(String clientId, String clientSecret, String tokenType, String tokenToIntrospect) {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            String string = this.introspectTokenWithClientCredential(clientId, clientSecret, tokenType, tokenToIntrospect, client);
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String introspectTokenWithClientCredential(String clientId, String clientSecret, String tokenType, String tokenToIntrospect, CloseableHttpClient client) {
        UrlEncodedFormEntity formEntity;
        HttpPost post = new HttpPost(this.getTokenIntrospectionUrl());
        if (this.requestHeaders != null) {
            for (Map.Entry<String, String> header : this.requestHeaders.entrySet()) {
                post.addHeader(header.getKey(), header.getValue());
            }
        }
        String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
        post.setHeader("Authorization", authorization);
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("token", tokenToIntrospect));
        parameters.add(new BasicNameValuePair("token_type_hint", tokenType));
        try {
            formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        post.setEntity((HttpEntity)formEntity);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            response.getEntity().writeTo((OutputStream)out);
            String string = new String(out.toByteArray());
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve access token", e);
        }
    }

    public String introspectAccessTokenWithClientCredential(String clientId, String clientSecret, String tokenToIntrospect) {
        return this.introspectTokenWithClientCredential(clientId, clientSecret, "access_token", tokenToIntrospect);
    }

    public String introspectRefreshTokenWithClientCredential(String clientId, String clientSecret, String tokenToIntrospect) {
        return this.introspectTokenWithClientCredential(clientId, clientSecret, "refresh_token", tokenToIntrospect);
    }

    public AccessTokenResponse doGrantAccessTokenRequest(String clientSecret, String username, String password) throws Exception {
        return this.doGrantAccessTokenRequest(this.realm, username, password, null, this.clientId, clientSecret);
    }

    public AccessTokenResponse doGrantAccessTokenRequest(String clientSecret, String username, String password, String otp) throws Exception {
        return this.doGrantAccessTokenRequest(this.realm, username, password, otp, this.clientId, clientSecret);
    }

    public AccessTokenResponse doGrantAccessTokenRequest(String realm, String username, String password, String totp, String clientId, String clientSecret) throws Exception {
        return this.doGrantAccessTokenRequest(realm, username, password, totp, clientId, clientSecret, null);
    }

    public AccessTokenResponse doGrantAccessTokenRequest(String realm, String username, String password, String totp, String clientId, String clientSecret, String userAgent) throws Exception {
        try (CloseableHttpClient client = this.httpClient.get();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getResourceOwnerPasswordCredentialGrantUrl(realm));
            if (this.requestHeaders != null) {
                for (Map.Entry<String, String> header : this.requestHeaders.entrySet()) {
                    post.addHeader(header.getKey(), header.getValue());
                }
            }
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "password"));
            parameters.add(new BasicNameValuePair("username", username));
            parameters.add(new BasicNameValuePair("password", password));
            if (totp != null) {
                parameters.add(new BasicNameValuePair("otp", totp));
            }
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            } else {
                parameters.add(new BasicNameValuePair("client_id", clientId));
            }
            if (this.origin != null) {
                post.addHeader("Origin", this.origin);
            }
            if (this.clientSessionState != null) {
                parameters.add(new BasicNameValuePair("client_session_state", this.clientSessionState));
            }
            if (this.clientSessionHost != null) {
                parameters.add(new BasicNameValuePair("client_session_host", this.clientSessionHost));
            }
            if (this.scope != null) {
                parameters.add(new BasicNameValuePair("scope", this.scope));
            }
            if (userAgent != null) {
                post.addHeader("User-Agent", userAgent);
            }
            if (this.customParameters != null) {
                this.customParameters.keySet().stream().forEach(paramName -> parameters.add(new BasicNameValuePair(paramName, this.customParameters.get(paramName))));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            AccessTokenResponse accessTokenResponse = new AccessTokenResponse(client.execute((HttpUriRequest)post));
            return accessTokenResponse;
        }
    }

    public AccessTokenResponse doTokenExchange(String realm, String token, String targetAudience, String clientId, String clientSecret) throws Exception {
        return this.doTokenExchange(realm, token, targetAudience, clientId, clientSecret, null);
    }

    public AccessTokenResponse doTokenExchange(String realm, String token, String targetAudience, String clientId, String clientSecret, Map<String, String> additionalParams) throws Exception {
        try (CloseableHttpClient client = this.httpClient.get();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getResourceOwnerPasswordCredentialGrantUrl(realm));
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange"));
            parameters.add(new BasicNameValuePair("subject_token", token));
            parameters.add(new BasicNameValuePair("subject_token_type", "urn:ietf:params:oauth:token-type:access_token"));
            parameters.add(new BasicNameValuePair("audience", targetAudience));
            if (additionalParams != null) {
                for (Map.Entry<String, String> entry : additionalParams.entrySet()) {
                    parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
            }
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            } else {
                parameters.add(new BasicNameValuePair("client_id", clientId));
            }
            if (this.clientSessionState != null) {
                parameters.add(new BasicNameValuePair("client_session_state", this.clientSessionState));
            }
            if (this.clientSessionHost != null) {
                parameters.add(new BasicNameValuePair("client_session_host", this.clientSessionHost));
            }
            if (this.scope != null) {
                parameters.add(new BasicNameValuePair("scope", this.scope));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            AccessTokenResponse accessTokenResponse = new AccessTokenResponse(client.execute((HttpUriRequest)post));
            return accessTokenResponse;
        }
    }

    public AccessTokenResponse doTokenExchange(String realm, String clientId, String clientSecret, Map<String, String> params) throws Exception {
        try (CloseableHttpClient client = this.httpClient.get();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getResourceOwnerPasswordCredentialGrantUrl(realm));
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange"));
            for (Map.Entry<String, String> entry : params.entrySet()) {
                parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            } else {
                parameters.add(new BasicNameValuePair("client_id", clientId));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            AccessTokenResponse accessTokenResponse = new AccessTokenResponse(client.execute((HttpUriRequest)post));
            return accessTokenResponse;
        }
    }

    public JSONWebKeySet doCertsRequest(String realm) throws Exception {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            HttpGet get = new HttpGet(this.getCertsUrl(realm));
            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
            JSONWebKeySet jSONWebKeySet = (JSONWebKeySet)JsonSerialization.readValue((InputStream)response.getEntity().getContent(), JSONWebKeySet.class);
            return jSONWebKeySet;
        }
    }

    public AccessTokenResponse doClientCredentialsGrantAccessTokenRequest(String clientSecret) throws Exception {
        try (CloseableHttpClient client = this.httpClient.get();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getServiceAccountUrl());
            String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)clientSecret);
            post.setHeader("Authorization", authorization);
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "client_credentials"));
            if (this.scope != null) {
                parameters.add(new BasicNameValuePair("scope", this.scope));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            AccessTokenResponse accessTokenResponse = new AccessTokenResponse(client.execute((HttpUriRequest)post));
            return accessTokenResponse;
        }
    }

    public AuthenticationRequestAcknowledgement doBackchannelAuthenticationRequest(String clientId, String clientSecret, String userid, String bindingMessage, String acrValues) throws Exception {
        return this.doBackchannelAuthenticationRequest(clientId, clientSecret, userid, bindingMessage, acrValues, null, null);
    }

    public AuthenticationRequestAcknowledgement doBackchannelAuthenticationRequest(String clientId, String clientSecret, String userid, String bindingMessage, String acrValues, String clientNotificationToken, Map<String, String> additionalParams) throws Exception {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getBackchannelAuthenticationUrl());
            String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
            post.setHeader("Authorization", authorization);
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            if (userid != null) {
                parameters.add(new BasicNameValuePair("login_hint", userid));
            }
            if (bindingMessage != null) {
                parameters.add(new BasicNameValuePair("binding_message", bindingMessage));
            }
            if (acrValues != null) {
                parameters.add(new BasicNameValuePair("acr_values", acrValues));
            }
            if (clientNotificationToken != null) {
                parameters.add(new BasicNameValuePair("client_notification_token", clientNotificationToken));
            }
            if (this.scope != null) {
                parameters.add(new BasicNameValuePair("scope", "openid " + this.scope));
            } else {
                parameters.add(new BasicNameValuePair("scope", "openid"));
            }
            if (this.requestUri != null) {
                parameters.add(new BasicNameValuePair("request_uri", this.requestUri));
            }
            if (this.request != null) {
                parameters.add(new BasicNameValuePair("request", this.request));
            }
            if (additionalParams != null) {
                for (Map.Entry<String, String> entry : additionalParams.entrySet()) {
                    parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            AuthenticationRequestAcknowledgement authenticationRequestAcknowledgement = new AuthenticationRequestAcknowledgement(client.execute((HttpUriRequest)post));
            return authenticationRequestAcknowledgement;
        }
    }

    public int doAuthenticationChannelCallback(String requestToken, AuthenticationChannelResponse.Status authStatus) throws Exception {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            HttpPost post = new HttpPost(this.getAuthenticationChannelCallbackUrl());
            String authorization = "Bearer " + requestToken;
            post.setHeader("Authorization", authorization);
            post.setEntity((HttpEntity)new StringEntity(JsonSerialization.writeValueAsString((Object)new AuthenticationChannelResponse(authStatus)), ContentType.APPLICATION_JSON));
            int n = client.execute((HttpUriRequest)post).getStatusLine().getStatusCode();
            return n;
        }
    }

    public AccessTokenResponse doBackchannelAuthenticationTokenRequest(String clientSecret, String authReqId) throws Exception {
        return this.doBackchannelAuthenticationTokenRequest(this.clientId, clientSecret, authReqId);
    }

    public AccessTokenResponse doBackchannelAuthenticationTokenRequest(String clientId, String clientSecret, String authReqId) throws Exception {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            AccessTokenResponse accessTokenResponse = this.doBackchannelAuthenticationTokenRequest(clientId, clientSecret, authReqId, client);
            return accessTokenResponse;
        }
    }

    public AccessTokenResponse doBackchannelAuthenticationTokenRequest(String clientId, String clientSecret, String authReqId, CloseableHttpClient client) throws Exception {
        UrlEncodedFormEntity formEntity;
        HttpPost post = new HttpPost(this.getBackchannelAuthenticationTokenRequestUrl());
        String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
        post.setHeader("Authorization", authorization);
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "urn:openid:params:grant-type:ciba"));
        parameters.add(new BasicNameValuePair("auth_req_id", authReqId));
        try {
            formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        post.setEntity((HttpEntity)formEntity);
        return new AccessTokenResponse(client.execute((HttpUriRequest)post));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CloseableHttpResponse doLogout(String refreshToken, String clientSecret) {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            CloseableHttpResponse closeableHttpResponse = this.doLogout(refreshToken, clientSecret, client);
            return closeableHttpResponse;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public CloseableHttpResponse doLogout(String refreshToken, String clientSecret, CloseableHttpClient client) throws IOException {
        UrlEncodedFormEntity formEntity;
        HttpPost post = new HttpPost(this.getLogoutUrl().build());
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        if (refreshToken != null) {
            parameters.add(new BasicNameValuePair("refresh_token", refreshToken));
        }
        if (this.clientId != null && clientSecret != null) {
            String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)clientSecret);
            post.setHeader("Authorization", authorization);
        } else if (this.clientId != null) {
            parameters.add(new BasicNameValuePair("client_id", this.clientId));
        }
        if (this.origin != null) {
            post.addHeader("Origin", this.origin);
        }
        try {
            formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        post.setEntity((HttpEntity)formEntity);
        return client.execute((HttpUriRequest)post);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CloseableHttpResponse doBackchannelLogout(String logoutTokon) {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            CloseableHttpResponse closeableHttpResponse = this.doBackchannelLogout(logoutTokon, client);
            return closeableHttpResponse;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public CloseableHttpResponse doBackchannelLogout(String logoutToken, CloseableHttpClient client) throws IOException {
        UrlEncodedFormEntity formEntity;
        HttpPost post = new HttpPost(this.getBackchannelLogoutUrl().build());
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        if (logoutToken != null) {
            parameters.add(new BasicNameValuePair("logout_token", logoutToken));
        }
        try {
            formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        post.setEntity((HttpEntity)formEntity);
        return client.execute((HttpUriRequest)post);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CloseableHttpResponse doTokenRevoke(String token, String tokenTypeHint, String clientSecret) {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            CloseableHttpResponse closeableHttpResponse = this.doTokenRevoke(token, tokenTypeHint, clientSecret, client);
            return closeableHttpResponse;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public CloseableHttpResponse doTokenRevoke(String token, String tokenTypeHint, String clientSecret, CloseableHttpClient client) throws IOException {
        UrlEncodedFormEntity formEntity;
        HttpPost post = new HttpPost(this.getTokenRevocationUrl());
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        if (token != null) {
            parameters.add(new BasicNameValuePair("token", token));
        }
        if (tokenTypeHint != null) {
            parameters.add(new BasicNameValuePair("token_type_hint", tokenTypeHint));
        }
        if (this.origin != null) {
            post.addHeader("Origin", this.origin);
        }
        if (this.clientId != null && clientSecret != null) {
            String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)clientSecret);
            post.setHeader("Authorization", authorization);
        } else if (this.clientId != null) {
            parameters.add(new BasicNameValuePair("client_id", this.clientId));
        }
        try {
            formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        post.setEntity((HttpEntity)formEntity);
        return client.execute((HttpUriRequest)post);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessTokenResponse doRefreshTokenRequest(String refreshToken, String password) {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            AccessTokenResponse accessTokenResponse = this.doRefreshTokenRequest(refreshToken, password, client);
            return accessTokenResponse;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public AccessTokenResponse doRefreshTokenRequest(String refreshToken, String password, CloseableHttpClient client) {
        UrlEncodedFormEntity formEntity;
        HttpPost post = new HttpPost(this.getRefreshTokenUrl());
        LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "refresh_token"));
        if (this.origin != null) {
            post.addHeader("Origin", this.origin);
        }
        if (refreshToken != null) {
            parameters.add(new BasicNameValuePair("refresh_token", refreshToken));
        }
        if (this.clientId != null && password != null) {
            String authorization = BasicAuthHelper.createHeader((String)this.clientId, (String)password);
            post.setHeader("Authorization", authorization);
        } else if (this.clientId != null) {
            parameters.add(new BasicNameValuePair("client_id", this.clientId));
        }
        if (this.clientSessionState != null) {
            parameters.add(new BasicNameValuePair("client_session_state", this.clientSessionState));
        }
        if (this.clientSessionHost != null) {
            parameters.add(new BasicNameValuePair("client_session_host", this.clientSessionHost));
        }
        try {
            formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        post.setEntity((HttpEntity)formEntity);
        try {
            return new AccessTokenResponse(client.execute((HttpUriRequest)post));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve access token", e);
        }
    }

    public DeviceAuthorizationResponse doDeviceAuthorizationRequest(String clientId, String clientSecret) throws Exception {
        try (CloseableHttpClient client = this.httpClient.get();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getDeviceAuthorizationUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            } else {
                parameters.add(new BasicNameValuePair("client_id", clientId));
            }
            if (this.origin != null) {
                post.addHeader("Origin", this.origin);
            }
            if (this.scope != null) {
                parameters.add(new BasicNameValuePair("scope", this.scope));
            }
            if (this.nonce != null) {
                parameters.add(new BasicNameValuePair("nonce", this.scope));
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            DeviceAuthorizationResponse deviceAuthorizationResponse = new DeviceAuthorizationResponse(client.execute((HttpUriRequest)post));
            return deviceAuthorizationResponse;
        }
    }

    public AccessTokenResponse doDeviceTokenRequest(String clientId, String clientSecret, String deviceCode) throws Exception {
        try (CloseableHttpClient client = this.httpClient.get();){
            UrlEncodedFormEntity formEntity;
            HttpPost post = new HttpPost(this.getAccessTokenUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:device_code"));
            parameters.add(new BasicNameValuePair("device_code", deviceCode));
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            } else {
                parameters.add(new BasicNameValuePair("client_id", clientId));
            }
            if (this.origin != null) {
                post.addHeader("Origin", this.origin);
            }
            try {
                formEntity = new UrlEncodedFormEntity(parameters, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            post.setEntity((HttpEntity)formEntity);
            AccessTokenResponse accessTokenResponse = new AccessTokenResponse(client.execute((HttpUriRequest)post));
            return accessTokenResponse;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OIDCConfigurationRepresentation doWellKnownRequest(String realm) {
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            SimpleHttp request = SimpleHttp.doGet((String)(this.baseUrl + "/realms/" + realm + "/.well-known/openid-configuration"), (HttpClient)client);
            if (this.requestHeaders != null) {
                for (Map.Entry entry : this.requestHeaders.entrySet()) {
                    request.header((String)entry.getKey(), (String)entry.getValue());
                }
            }
            OIDCConfigurationRepresentation oIDCConfigurationRepresentation = (OIDCConfigurationRepresentation)request.asJson(OIDCConfigurationRepresentation.class);
            return oIDCConfigurationRepresentation;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    public UserInfo doUserInfoRequest(String accessToken) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ParResponse doPushedAuthorizationRequest(String clientId, String clientSecret) throws IOException {
        return this.doPushedAuthorizationRequest(clientId, clientSecret, c -> {});
    }

    public ParResponse doPushedAuthorizationRequest(String clientId, String clientSecret, Consumer<CloseableHttpResponse> c) throws IOException {
        Throwable throwable = null;
        try (CloseableHttpClient client = org.apache.http.impl.client.HttpClientBuilder.create().build();){
            String scopeParam;
            HttpPost post = new HttpPost(this.getParEndpointUrl());
            LinkedList<BasicNameValuePair> parameters = new LinkedList<BasicNameValuePair>();
            if (this.origin != null) {
                post.addHeader("Origin", this.origin);
            }
            if (this.responseType != null) {
                parameters.add(new BasicNameValuePair("response_type", this.responseType));
            }
            if (this.responseMode != null) {
                parameters.add(new BasicNameValuePair("response_mode", this.responseMode));
            }
            if (clientId != null && clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)clientId, (String)clientSecret);
                post.setHeader("Authorization", authorization);
                parameters.add(new BasicNameValuePair("client_id", clientId));
            }
            if (this.redirectUri != null) {
                parameters.add(new BasicNameValuePair("redirect_uri", this.redirectUri));
            }
            if (this.kcAction != null) {
                parameters.add(new BasicNameValuePair("kc_action", this.kcAction));
            }
            if (this.uiLocales != null) {
                parameters.add(new BasicNameValuePair("ui_locales", this.uiLocales));
            }
            if (this.nonce != null) {
                parameters.add(new BasicNameValuePair("nonce", this.nonce));
            }
            String string = scopeParam = this.openid ? TokenUtil.attachOIDCScope((String)this.scope) : this.scope;
            if (scopeParam != null && !scopeParam.isEmpty()) {
                parameters.add(new BasicNameValuePair("scope", scopeParam));
            }
            if (this.maxAge != null) {
                parameters.add(new BasicNameValuePair("max_age", this.maxAge));
            }
            if (this.request != null) {
                parameters.add(new BasicNameValuePair("request", this.request));
            }
            if (this.requestUri != null) {
                parameters.add(new BasicNameValuePair("request_uri", this.requestUri));
            }
            if (this.codeChallenge != null) {
                parameters.add(new BasicNameValuePair("code_challenge", this.codeChallenge));
            }
            if (this.codeChallengeMethod != null) {
                parameters.add(new BasicNameValuePair("code_challenge_method", this.codeChallengeMethod));
            }
            if (this.customParameters != null) {
                this.customParameters.keySet().stream().forEach(i -> parameters.add(new BasicNameValuePair(i, this.customParameters.get(i))));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, Charsets.UTF_8);
            post.setEntity((HttpEntity)formEntity);
            try {
                ParResponse parResponse = new ParResponse(client.execute((HttpUriRequest)post), c);
                return parResponse;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw new RuntimeException("Failed to do PAR request", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public void closeClient(CloseableHttpClient client) {
        try {
            client.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public AccessToken verifyToken(String token) {
        return this.verifyToken(token, AccessToken.class);
    }

    public IDToken verifyIDToken(String token) {
        return this.verifyToken(token, IDToken.class);
    }

    public AuthorizationResponseToken verifyAuthorizationResponseToken(String token) {
        return this.verifyToken(token, AuthorizationResponseToken.class);
    }

    public RefreshToken parseRefreshToken(String refreshToken) {
        try {
            return (RefreshToken)new JWSInput(refreshToken).readJsonContent(RefreshToken.class);
        }
        catch (Exception e) {
            throw new RunOnServerException((Throwable)e);
        }
    }

    public <T extends JsonWebToken> T verifyToken(String token, Class<T> clazz) {
        try {
            ServerECDSASignatureVerifierContext verifierContext;
            TokenVerifier verifier = TokenVerifier.create((String)token, clazz);
            String kid = verifier.getHeader().getKeyId();
            String algorithm = verifier.getHeader().getAlgorithm().name();
            KeyWrapper key = this.getRealmPublicKey(this.realm, algorithm, kid);
            switch (algorithm) {
                case "ES256": 
                case "ES384": 
                case "ES512": {
                    verifierContext = new ServerECDSASignatureVerifierContext(key);
                    break;
                }
                default: {
                    verifierContext = new AsymmetricSignatureVerifierContext(key);
                }
            }
            verifier.verifierContext((SignatureVerifierContext)verifierContext);
            verifier.verify();
            return (T)verifier.getToken();
        }
        catch (VerificationException e) {
            throw new RuntimeException("Failed to decode token", e);
        }
    }

    public SignatureSignerContext createSigner(PrivateKey privateKey, String kid, String algorithm) {
        ServerECDSASignatureSignerContext signer;
        KeyWrapper keyWrapper = new KeyWrapper();
        keyWrapper.setAlgorithm(algorithm);
        keyWrapper.setKid(kid);
        keyWrapper.setPrivateKey((Key)privateKey);
        switch (algorithm) {
            case "ES256": 
            case "ES384": 
            case "ES512": {
                signer = new ServerECDSASignatureSignerContext(keyWrapper);
                break;
            }
            default: {
                signer = new AsymmetricSignatureSignerContext(keyWrapper);
            }
        }
        return signer;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCurrentRequest() {
        int index = this.driver.getCurrentUrl().indexOf(63);
        if (index == -1) {
            index = this.driver.getCurrentUrl().indexOf(35);
        }
        return this.driver.getCurrentUrl().substring(0, index);
    }

    public URI getCurrentUri() {
        try {
            return new URI(this.driver.getCurrentUrl());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getCurrentQuery() {
        HashMap<String, String> m = new HashMap<String, String>();
        List pairs = URLEncodedUtils.parse((URI)this.getCurrentUri(), (String)"UTF-8");
        for (NameValuePair p : pairs) {
            m.put(p.getName(), p.getValue());
        }
        return m;
    }

    public Map<String, String> getCurrentFragment() {
        HashMap<String, String> m = new HashMap<String, String>();
        String fragment = this.getCurrentUri().getRawFragment();
        List pairs = fragment == null || fragment.isEmpty() ? Collections.emptyList() : URLEncodedUtils.parse((String)fragment, (Charset)Charset.forName("UTF-8"));
        for (NameValuePair p : pairs) {
            m.put(p.getName(), p.getValue());
        }
        return m;
    }

    public void openLoginForm() {
        this.driver.navigate().to(this.getLoginFormUrl());
    }

    public void openRegistrationForm() {
        this.driver.navigate().to(this.getRegistrationFormUrl());
    }

    public void openOAuth2DeviceVerificationForm(String verificationUri) {
        this.driver.navigate().to(verificationUri);
    }

    public void openLogout() {
        UriBuilder b = OIDCLoginProtocolService.logoutUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        if (this.redirectUri != null) {
            b.queryParam("redirect_uri", new Object[]{this.redirectUri});
        }
        this.driver.navigate().to(b.build(new Object[]{this.realm}).toString());
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getKcAction() {
        return this.kcAction;
    }

    public String getState() {
        return this.state.getState();
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getLoginFormUrl() {
        String scopeParam;
        String state;
        UriBuilder b = OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        if (this.responseType != null) {
            b.queryParam("response_type", new Object[]{this.responseType});
        }
        if (this.responseMode != null) {
            b.queryParam("response_mode", new Object[]{this.responseMode});
        }
        if (this.clientId != null) {
            b.queryParam("client_id", new Object[]{this.clientId});
        }
        if (this.redirectUri != null) {
            b.queryParam("redirect_uri", new Object[]{this.redirectUri});
        }
        if (this.kcAction != null) {
            b.queryParam("kc_action", new Object[]{this.kcAction});
        }
        if ((state = this.state.getState()) != null) {
            b.queryParam("state", new Object[]{state});
        }
        if (this.uiLocales != null) {
            b.queryParam("ui_locales", new Object[]{this.uiLocales});
        }
        if (this.nonce != null) {
            b.queryParam("nonce", new Object[]{this.nonce});
        }
        String string = scopeParam = this.openid ? TokenUtil.attachOIDCScope((String)this.scope) : this.scope;
        if (scopeParam != null && !scopeParam.isEmpty()) {
            b.queryParam("scope", new Object[]{scopeParam});
        }
        if (this.maxAge != null) {
            b.queryParam("max_age", new Object[]{this.maxAge});
        }
        if (this.request != null) {
            b.queryParam("request", new Object[]{this.request});
        }
        if (this.requestUri != null) {
            b.queryParam("request_uri", new Object[]{this.requestUri});
        }
        if (this.codeChallenge != null) {
            b.queryParam("code_challenge", new Object[]{this.codeChallenge});
        }
        if (this.codeChallengeMethod != null) {
            b.queryParam("code_challenge_method", new Object[]{this.codeChallengeMethod});
        }
        if (this.customParameters != null) {
            this.customParameters.keySet().stream().forEach(i -> b.queryParam(i, new Object[]{this.customParameters.get(i)}));
        }
        return b.build(new Object[]{this.realm}).toString();
    }

    private String getRegistrationFormUrl() {
        String scopeParam;
        UriBuilder b = OIDCLoginProtocolService.registrationsUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        if (this.responseType != null) {
            b.queryParam("response_type", new Object[]{this.responseType});
        }
        if (this.clientId != null) {
            b.queryParam("client_id", new Object[]{this.clientId});
        }
        if (this.redirectUri != null) {
            b.queryParam("redirect_uri", new Object[]{this.redirectUri});
        }
        String string = scopeParam = this.openid ? TokenUtil.attachOIDCScope((String)this.scope) : this.scope;
        if (scopeParam != null && !scopeParam.isEmpty()) {
            b.queryParam("scope", new Object[]{scopeParam});
        }
        if (this.customParameters != null) {
            this.customParameters.keySet().stream().forEach(i -> b.queryParam(i, new Object[]{this.customParameters.get(i)}));
        }
        return b.build(new Object[]{this.realm}).toString();
    }

    public Entity getLoginEntityForPOST() {
        Form form = new Form().param("scope", TokenUtil.attachOIDCScope((String)this.scope)).param("response_type", this.responseType).param("client_id", this.clientId).param("redirect_uri", this.redirectUri).param("state", this.state.getState());
        return Entity.form((Form)form);
    }

    public String getAccessTokenUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getTokenIntrospectionUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenIntrospectionUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public LogoutUrlBuilder getLogoutUrl() {
        return new LogoutUrlBuilder();
    }

    public BackchannelLogoutUrlBuilder getBackchannelLogoutUrl() {
        return new BackchannelLogoutUrlBuilder();
    }

    public String getTokenRevocationUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenRevocationUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getResourceOwnerPasswordCredentialGrantUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getResourceOwnerPasswordCredentialGrantUrl(String realm) {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{realm}).toString();
    }

    public String getCertsUrl(String realm) {
        UriBuilder b = OIDCLoginProtocolService.certsUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{realm}).toString();
    }

    public String getServiceAccountUrl() {
        return this.getResourceOwnerPasswordCredentialGrantUrl();
    }

    public String getDeviceAuthorizationUrl() {
        UriBuilder b = DeviceGrantType.oauth2DeviceAuthUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getRefreshTokenUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getUserInfoUrl() {
        UriBuilder b = OIDCLoginProtocolService.userInfoUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getBackchannelAuthenticationUrl() {
        UriBuilder b = CibaGrantType.authorizationUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getAuthenticationChannelCallbackUrl() {
        UriBuilder b = CibaGrantType.authenticationUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getBackchannelAuthenticationTokenRequestUrl() {
        UriBuilder b = OIDCLoginProtocolService.tokenUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public String getParEndpointUrl() {
        UriBuilder b = ParEndpoint.parUrl((UriBuilder)UriBuilder.fromUri((String)this.baseUrl));
        return b.build(new Object[]{this.realm}).toString();
    }

    public OAuthClient baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public OAuthClient realm(String realm) {
        this.realm = realm;
        return this;
    }

    public OAuthClient clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public OAuthClient redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public OAuthClient kcAction(String kcAction) {
        this.kcAction = kcAction;
        return this;
    }

    public OAuthClient stateParamHardcoded(String value) {
        this.state = () -> value;
        return this;
    }

    public OAuthClient stateParamRandom() {
        this.state = () -> KeycloakModelUtils.generateId();
        return this;
    }

    public OAuthClient scope(String scope) {
        this.scope = scope;
        return this;
    }

    public OAuthClient openid(boolean openid) {
        this.openid = openid;
        return this;
    }

    public OAuthClient uiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
        return this;
    }

    public OAuthClient clientSessionState(String client_session_state) {
        this.clientSessionState = client_session_state;
        return this;
    }

    public OAuthClient clientSessionHost(String client_session_host) {
        this.clientSessionHost = client_session_host;
        return this;
    }

    public OAuthClient maxAge(String maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public OAuthClient responseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    public OAuthClient responseMode(String responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    public OAuthClient nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public OAuthClient request(String request) {
        this.request = request;
        return this;
    }

    public OAuthClient requestUri(String requestUri) {
        this.requestUri = requestUri;
        return this;
    }

    public String getRealm() {
        return this.realm;
    }

    public OAuthClient codeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
        return this;
    }

    public OAuthClient codeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
        return this;
    }

    public OAuthClient codeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
        return this;
    }

    public OAuthClient origin(String origin) {
        this.origin = origin;
        return this;
    }

    public OAuthClient addCustomParameter(String key, String value) {
        if (this.customParameters == null) {
            this.customParameters = new HashMap<String, String>();
        }
        this.customParameters.put(key, value);
        return this;
    }

    public OAuthClient removeCustomParameter(String key) {
        if (this.customParameters != null) {
            this.customParameters.remove(key);
        }
        return this;
    }

    public OAuthClient requestHeaders(Map<String, String> headers) {
        this.requestHeaders = headers;
        return this;
    }

    private KeyWrapper getRealmPublicKey(String realm, String algoritm, String kid) {
        KeyWrapper key;
        boolean loadedKeysFromServer = false;
        JSONWebKeySet jsonWebKeySet = this.publicKeys.get(realm);
        if (jsonWebKeySet == null) {
            jsonWebKeySet = this.getRealmKeys(realm);
            this.publicKeys.put(realm, jsonWebKeySet);
            loadedKeysFromServer = true;
        }
        if ((key = this.findKey(jsonWebKeySet, algoritm, kid)) == null && !loadedKeysFromServer) {
            jsonWebKeySet = this.getRealmKeys(realm);
            this.publicKeys.put(realm, jsonWebKeySet);
            key = this.findKey(jsonWebKeySet, algoritm, kid);
        }
        if (key == null) {
            throw new RuntimeException("Public key for realm:" + realm + ", algorithm: " + algoritm + " not found");
        }
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONWebKeySet getRealmKeys(String realm) {
        String certUrl = this.baseUrl + "/realms/" + realm + "/protocol/openid-connect/certs";
        try (CloseableHttpClient client = this.httpClient.get();){
            JSONWebKeySet jSONWebKeySet = (JSONWebKeySet)SimpleHttp.doGet((String)certUrl, (HttpClient)client).asJson(JSONWebKeySet.class);
            return jSONWebKeySet;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve keys", e);
        }
    }

    private KeyWrapper findKey(JSONWebKeySet jsonWebKeySet, String algoritm, String kid) {
        for (JWK k : jsonWebKeySet.getKeys()) {
            if (!k.getKeyId().equals(kid) || !k.getAlgorithm().equals(algoritm)) continue;
            PublicKey publicKey = JWKParser.create((JWK)k).toPublicKey();
            KeyWrapper key = new KeyWrapper();
            key.setKid(k.getKeyId());
            key.setAlgorithm(k.getAlgorithm());
            key.setPublicKey((Key)publicKey);
            key.setUse(KeyUse.SIG);
            return key;
        }
        return null;
    }

    public void removeCachedPublicKeys() {
        this.publicKeys.clear();
    }

    public void setBrowserHeader(String name, String value) {
        if (this.driver instanceof DroneHtmlUnitDriver) {
            DroneHtmlUnitDriver droneDriver = (DroneHtmlUnitDriver)this.driver;
            droneDriver.getWebClient().removeRequestHeader(name);
            droneDriver.getWebClient().addRequestHeader(name, value);
        }
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    private WebElement findSocialButton(String alias) {
        String id = "social-" + alias;
        return DroneUtils.getCurrentDriver().findElement(By.id((String)id));
    }

    static {
        sslRequired = Boolean.parseBoolean(System.getProperty("auth.server.ssl.required"));
        OAuthClient.updateURLs(ServerURLs.getAuthServerContextRoot());
    }

    public static class DeviceAuthorizationResponse {
        private int statusCode;
        private String deviceCode;
        private String userCode;
        private String verificationUri;
        private String verificationUriComplete;
        private int expiresIn;
        private int interval;
        private String error;
        private String errorDescription;
        private Map<String, String> headers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DeviceAuthorizationResponse(CloseableHttpResponse response) throws Exception {
            try {
                String contentType;
                this.statusCode = response.getStatusLine().getStatusCode();
                this.headers = new HashMap<String, String>();
                for (Header h : response.getAllHeaders()) {
                    this.headers.put(h.getName(), h.getValue());
                }
                Header[] contentTypeHeaders = response.getHeaders("Content-Type");
                String string = contentType = contentTypeHeaders != null && contentTypeHeaders.length > 0 ? contentTypeHeaders[0].getValue() : null;
                if (!"application/json".equals(contentType)) {
                    Assert.fail((String)("Invalid content type. Status: " + this.statusCode + ", contentType: " + contentType));
                }
                String s = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                Map responseJson = (Map)JsonSerialization.readValue((String)s, Map.class);
                if (this.statusCode == 200) {
                    this.deviceCode = (String)responseJson.get("device_code");
                    this.userCode = (String)responseJson.get("user_code");
                    this.verificationUri = (String)responseJson.get("verification_uri");
                    this.verificationUriComplete = (String)responseJson.get("verification_uri_complete");
                    this.expiresIn = (Integer)responseJson.get("expires_in");
                    this.interval = (Integer)responseJson.get("interval");
                } else {
                    this.error = (String)responseJson.get("error");
                    this.errorDescription = responseJson.containsKey("error_description") ? (String)responseJson.get("error_description") : null;
                }
            }
            finally {
                response.close();
            }
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public String getDeviceCode() {
            return this.deviceCode;
        }

        public String getUserCode() {
            return this.userCode;
        }

        public String getVerificationUri() {
            return this.verificationUri;
        }

        public String getVerificationUriComplete() {
            return this.verificationUriComplete;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public int getInterval() {
            return this.interval;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }

    private static interface StateParamProvider {
        public String getState();
    }

    public static class AccessTokenResponse {
        private int statusCode;
        private String idToken;
        private String accessToken;
        private String issuedTokenType;
        private String tokenType;
        private int expiresIn;
        private int refreshExpiresIn;
        private String refreshToken;
        private String scope;
        private String sessionState;
        private String error;
        private String errorDescription;
        private Map<String, String> headers;
        private Map<String, Object> otherClaims;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AccessTokenResponse(CloseableHttpResponse response) throws Exception {
            try {
                String contentType;
                this.statusCode = response.getStatusLine().getStatusCode();
                this.headers = new HashMap<String, String>();
                for (Header h : response.getAllHeaders()) {
                    this.headers.put(h.getName(), h.getValue());
                }
                Header[] contentTypeHeaders = response.getHeaders("Content-Type");
                String string = contentType = contentTypeHeaders != null && contentTypeHeaders.length > 0 ? contentTypeHeaders[0].getValue() : null;
                if (!"application/json".equals(contentType)) {
                    Assert.fail((String)("Invalid content type. Status: " + this.statusCode + ", contentType: " + contentType));
                }
                String s = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                Map responseJson = (Map)JsonSerialization.readValue((String)s, Map.class);
                if (this.statusCode == 200) {
                    this.otherClaims = new HashMap<String, Object>();
                    block26: for (Map.Entry entry : responseJson.entrySet()) {
                        switch ((String)entry.getKey()) {
                            case "id_token": {
                                this.idToken = (String)entry.getValue();
                                continue block26;
                            }
                            case "access_token": {
                                this.accessToken = (String)entry.getValue();
                                continue block26;
                            }
                            case "issued_token_type": {
                                this.issuedTokenType = (String)entry.getValue();
                                continue block26;
                            }
                            case "token_type": {
                                this.tokenType = (String)entry.getValue();
                                continue block26;
                            }
                            case "expires_in": {
                                this.expiresIn = (Integer)entry.getValue();
                                continue block26;
                            }
                            case "refresh_expires_in": {
                                this.refreshExpiresIn = (Integer)entry.getValue();
                                continue block26;
                            }
                            case "session_state": {
                                this.sessionState = (String)entry.getValue();
                                continue block26;
                            }
                            case "scope": {
                                this.scope = (String)entry.getValue();
                                continue block26;
                            }
                            case "refresh_token": {
                                this.refreshToken = (String)entry.getValue();
                                continue block26;
                            }
                        }
                        this.otherClaims.put((String)entry.getKey(), entry.getValue());
                    }
                } else {
                    this.error = (String)responseJson.get("error");
                    this.errorDescription = responseJson.containsKey("error_description") ? (String)responseJson.get("error_description") : null;
                }
            }
            finally {
                response.close();
            }
        }

        public String getIdToken() {
            return this.idToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public int getRefreshExpiresIn() {
            return this.refreshExpiresIn;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getIssuedTokenType() {
            return this.issuedTokenType;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getScope() {
            return this.scope;
        }

        public String getSessionState() {
            return this.sessionState;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Map<String, Object> getOtherClaims() {
            return this.otherClaims;
        }
    }

    public static class AuthenticationRequestAcknowledgement {
        private int statusCode;
        private Map<String, String> headers;
        private String authReqId;
        private int expiresIn;
        private int interval = -1;
        private String error;
        private String errorDescription;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthenticationRequestAcknowledgement(CloseableHttpResponse response) throws Exception {
            try {
                String contentType;
                this.statusCode = response.getStatusLine().getStatusCode();
                this.headers = new HashMap<String, String>();
                for (Header h : response.getAllHeaders()) {
                    this.headers.put(h.getName(), h.getValue());
                }
                Header[] contentTypeHeaders = response.getHeaders("Content-Type");
                String string = contentType = contentTypeHeaders != null && contentTypeHeaders.length > 0 ? contentTypeHeaders[0].getValue() : null;
                if (!"application/json".equals(contentType)) {
                    Assert.fail((String)("Invalid content type. Status: " + this.statusCode + ", contentType: " + contentType));
                }
                String s = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                Map responseJson = (Map)JsonSerialization.readValue((String)s, Map.class);
                if (this.statusCode == 200) {
                    this.authReqId = (String)responseJson.get("auth_req_id");
                    this.expiresIn = (Integer)responseJson.get("expires_in");
                    if (responseJson.containsKey("interval")) {
                        this.interval = (Integer)responseJson.get("interval");
                    }
                } else {
                    this.error = (String)responseJson.get("error");
                    this.errorDescription = responseJson.containsKey("error_description") ? (String)responseJson.get("error_description") : null;
                }
            }
            finally {
                response.close();
            }
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getAuthReqId() {
            return this.authReqId;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public int getInterval() {
            return this.interval;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }
    }

    public static class AuthorizationEndpointResponse {
        private boolean isRedirected;
        private String code;
        private String state;
        private String error;
        private String errorDescription;
        private String sessionState;
        private String accessToken;
        private String idToken;
        private String tokenType;
        private String expiresIn;
        private String response;

        public AuthorizationEndpointResponse(OAuthClient client) {
            boolean fragment;
            if (client.responseMode == null || "jwt".equals(client.responseMode)) {
                try {
                    fragment = client.responseType != null && OIDCResponseType.parse((String)client.responseType).isImplicitOrHybridFlow();
                }
                catch (IllegalArgumentException iae) {
                    fragment = false;
                }
            } else {
                fragment = "fragment".equals(client.responseMode) || "fragment.jwt".equals(client.responseMode);
            }
            this.init(client, fragment);
        }

        public AuthorizationEndpointResponse(OAuthClient client, boolean fragment) {
            this.init(client, fragment);
        }

        private void init(OAuthClient client, boolean fragment) {
            this.isRedirected = client.getCurrentRequest().equals(client.getRedirectUri());
            Map<String, String> params = fragment ? client.getCurrentFragment() : client.getCurrentQuery();
            this.code = params.get("code");
            this.state = params.get("state");
            this.error = params.get("error");
            this.errorDescription = params.get("error_description");
            this.sessionState = params.get("session_state");
            this.accessToken = params.get("access_token");
            this.idToken = params.get("id_token");
            this.tokenType = params.get("token_type");
            this.expiresIn = params.get("expires_in");
            this.response = params.get("response");
        }

        public boolean isRedirected() {
            return this.isRedirected;
        }

        public String getCode() {
            return this.code;
        }

        public String getState() {
            return this.state;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public String getSessionState() {
            return this.sessionState;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getExpiresIn() {
            return this.expiresIn;
        }

        public String getResponse() {
            return this.response;
        }
    }

    public static class ParResponse {
        private int statusCode;
        private Map<String, String> headers;
        private String requestUri;
        private int expiresIn;
        private String error;
        private String errorDescription;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ParResponse(CloseableHttpResponse response, Consumer<CloseableHttpResponse> c) throws Exception {
            try {
                String contentType;
                this.statusCode = response.getStatusLine().getStatusCode();
                this.headers = new HashMap<String, String>();
                for (Header h : response.getAllHeaders()) {
                    this.headers.put(h.getName(), h.getValue());
                }
                Header[] contentTypeHeaders = response.getHeaders("Content-Type");
                String string = contentType = contentTypeHeaders != null && contentTypeHeaders.length > 0 ? contentTypeHeaders[0].getValue() : null;
                if (!"application/json".equals(contentType)) {
                    Assert.fail((String)("Invalid content type. Status: " + this.statusCode + ", contentType: " + contentType));
                }
                String s = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                Map responseJson = (Map)JsonSerialization.readValue((String)s, Map.class);
                if (this.statusCode == 201) {
                    this.requestUri = (String)responseJson.get("request_uri");
                    this.expiresIn = (Integer)responseJson.get("expires_in");
                } else {
                    this.error = (String)responseJson.get("error");
                    this.errorDescription = responseJson.containsKey("error_description") ? (String)responseJson.get("error_description") : null;
                }
                c.accept(response);
            }
            finally {
                response.close();
            }
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getRequestUri() {
            return this.requestUri;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }
    }

    public class BackchannelLogoutUrlBuilder {
        private final String backchannelLogoutPath = "/backchannel-logout";
        private final UriBuilder b = OIDCLoginProtocolService.logoutUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.access$000(OAuthClient.this))).path("/backchannel-logout");

        public String build() {
            return this.b.build(new Object[]{OAuthClient.this.realm}).toString();
        }
    }

    public class LogoutUrlBuilder {
        private final UriBuilder b;

        public LogoutUrlBuilder() {
            this.b = OIDCLoginProtocolService.logoutUrl((UriBuilder)UriBuilder.fromUri((String)OAuthClient.this.baseUrl));
        }

        public LogoutUrlBuilder idTokenHint(String idTokenHint) {
            if (idTokenHint != null) {
                this.b.queryParam("id_token_hint", new Object[]{idTokenHint});
            }
            return this;
        }

        public LogoutUrlBuilder postLogoutRedirectUri(String redirectUri) {
            if (redirectUri != null) {
                this.b.queryParam("post_logout_redirect_uri", new Object[]{redirectUri});
            }
            return this;
        }

        public LogoutUrlBuilder redirectUri(String redirectUri) {
            if (redirectUri != null) {
                this.b.queryParam("redirect_uri", new Object[]{redirectUri});
            }
            return this;
        }

        public LogoutUrlBuilder sessionState(String sessionState) {
            if (sessionState != null) {
                this.b.queryParam("session_state", new Object[]{sessionState});
            }
            return this;
        }

        public String build() {
            return this.b.build(new Object[]{OAuthClient.this.realm}).toString();
        }
    }
}

