/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.testsuite.util.UserInfoClientUtil;

public class MutualTLSUtils {
    public static final String DEFAULT_KEYSTOREPATH = System.getProperty("client.certificate.keystore");
    public static final String DEFAULT_KEYSTOREPASSWORD = System.getProperty("client.certificate.keystore.passphrase");
    public static final String DEFAULT_TRUSTSTOREPATH = System.getProperty("client.truststore");
    public static final String DEFAULT_TRUSTSTOREPASSWORD = System.getProperty("client.truststore.passphrase");
    public static final String OTHER_KEYSTOREPATH = System.getProperty("hok.client.certificate.keystore");
    public static final String OTHER_KEYSTOREPASSWORD = System.getProperty("hok.client.certificate.keystore.passphrase");
    public static final String OBB_KEYSTOREPATH = System.getProperty("obb.client.certificate.keystore");
    public static final String OBB_KEYSTOREPASSWORD = System.getProperty("obb.client.certificate.keystore.passphrase");

    public static CloseableHttpClient newCloseableHttpClientWithDefaultKeyStoreAndTrustStore() {
        return MutualTLSUtils.newCloseableHttpClient(DEFAULT_KEYSTOREPATH, DEFAULT_KEYSTOREPASSWORD, DEFAULT_TRUSTSTOREPATH, DEFAULT_TRUSTSTOREPASSWORD);
    }

    public static CloseableHttpClient newCloseableHttpClientWithOtherKeyStoreAndTrustStore() {
        return MutualTLSUtils.newCloseableHttpClient(OTHER_KEYSTOREPATH, OTHER_KEYSTOREPASSWORD, DEFAULT_TRUSTSTOREPATH, DEFAULT_TRUSTSTOREPASSWORD);
    }

    public static CloseableHttpClient newCloseableHttpClientWithOBBKeyStoreAndTrustStore() {
        return MutualTLSUtils.newCloseableHttpClient(OBB_KEYSTOREPATH, OBB_KEYSTOREPASSWORD, DEFAULT_TRUSTSTOREPATH, DEFAULT_TRUSTSTOREPASSWORD);
    }

    public static CloseableHttpClient newCloseableHttpClientWithoutKeyStoreAndTrustStore() {
        return MutualTLSUtils.newCloseableHttpClient(null, null, null, null);
    }

    public static CloseableHttpClient newCloseableHttpClient(String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword) {
        KeyStore keystore = null;
        if (keyStorePath != null) {
            try {
                keystore = KeystoreUtil.loadKeyStore((String)keyStorePath, (String)keyStorePassword);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        KeyStore truststore = null;
        if (trustStorePath != null) {
            try {
                truststore = KeystoreUtil.loadKeyStore((String)trustStorePath, (String)trustStorePassword);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (keystore != null || truststore != null) {
            return (CloseableHttpClient)new HttpClientBuilder().keyStore(keystore, keyStorePassword).trustStore(truststore).hostnameVerification(HttpClientBuilder.HostnameVerificationPolicy.ANY).build();
        }
        return org.apache.http.impl.client.HttpClientBuilder.create().build();
    }

    public static String getThumbprintFromDefaultClientCert() throws KeyStoreException, CertificateEncodingException {
        return MutualTLSUtils.getThumbprintFromClientCert(DEFAULT_KEYSTOREPATH, DEFAULT_KEYSTOREPASSWORD);
    }

    public static String getThumbprintFromOtherClientCert() throws KeyStoreException, CertificateEncodingException {
        return MutualTLSUtils.getThumbprintFromClientCert(OTHER_KEYSTOREPATH, OTHER_KEYSTOREPASSWORD);
    }

    public static String getThumbprintFromClientCert(String keyStorePath, String keyStorePassword) throws KeyStoreException, CertificateEncodingException {
        KeyStore keystore = null;
        try {
            keystore = KeystoreUtil.loadKeyStore((String)keyStorePath, (String)keyStorePassword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Enumeration<String> es = keystore.aliases();
        String alias = null;
        while (es.hasMoreElements()) {
            alias = es.nextElement();
        }
        X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
        String digestAlg = "SHA-256";
        byte[] DERX509Hash = cert.getEncoded();
        String DERX509Base64UrlEncoded = null;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlg);
            md.update(DERX509Hash);
            DERX509Base64UrlEncoded = Base64Url.encode((byte[])md.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return DERX509Base64UrlEncoded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response executeUserInfoRequestInGetMethod(String accessToken, boolean isKeystoreUsed, String keystorePath, String keystorePassward) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        KeyStore keystore = null;
        if (isKeystoreUsed) {
            try {
                if (keystorePath != null) {
                    keystore = KeystoreUtil.loadKeyStore((String)keystorePath, (String)keystorePassward);
                    clientBuilder.keyStore(keystore, keystorePassward);
                } else {
                    keystore = KeystoreUtil.loadKeyStore((String)DEFAULT_KEYSTOREPATH, (String)DEFAULT_KEYSTOREPASSWORD);
                    clientBuilder.keyStore(keystore, DEFAULT_KEYSTOREPASSWORD);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WebTarget userInfoTarget = null;
        try (Client client = clientBuilder.build();){
            userInfoTarget = UserInfoClientUtil.getUserInfoWebTarget(client);
        }
        return userInfoTarget.request().header("Authorization", (Object)("bearer " + accessToken)).get();
    }
}

