/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.http.HttpResponse;
import org.hamcrest.Matcher;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.testsuite.util.matchers.HttpResponseBodyMatcher;
import org.keycloak.testsuite.util.matchers.HttpResponseStatusCodeMatcher;
import org.keycloak.testsuite.util.matchers.ResponseBodyMatcher;
import org.keycloak.testsuite.util.matchers.ResponseHeaderMatcher;
import org.keycloak.testsuite.util.matchers.ResponseStatusCodeMatcher;
import org.keycloak.testsuite.util.matchers.SamlLogoutRequestTypeMatcher;
import org.keycloak.testsuite.util.matchers.SamlResponseTypeMatcher;
import org.keycloak.testsuite.util.matchers.SamlStatusResponseTypeMatcher;

public class Matchers {
    public static Matcher<Response> body(Matcher<String> matcher) {
        return new ResponseBodyMatcher(matcher);
    }

    public static Matcher<HttpResponse> bodyHC(Matcher<String> matcher) {
        return new HttpResponseBodyMatcher(matcher);
    }

    public static Matcher<Response> statusCode(Matcher<? extends Number> matcher) {
        return new ResponseStatusCodeMatcher(matcher);
    }

    public static Matcher<HttpResponse> statusCodeHC(Matcher<? extends Number> matcher) {
        return new HttpResponseStatusCodeMatcher(matcher);
    }

    public static Matcher<Response> statusCodeIs(Response.Status expectedStatusCode) {
        return new ResponseStatusCodeMatcher((Matcher<? extends Number>)org.hamcrest.Matchers.is((Object)expectedStatusCode.getStatusCode()));
    }

    public static Matcher<HttpResponse> statusCodeIsHC(Response.Status expectedStatusCode) {
        return new HttpResponseStatusCodeMatcher((Matcher<? extends Number>)org.hamcrest.Matchers.is((Object)expectedStatusCode.getStatusCode()));
    }

    public static Matcher<Response> statusCodeIs(int expectedStatusCode) {
        return new ResponseStatusCodeMatcher((Matcher<? extends Number>)org.hamcrest.Matchers.is((Object)expectedStatusCode));
    }

    public static Matcher<HttpResponse> statusCodeIsHC(int expectedStatusCode) {
        return new HttpResponseStatusCodeMatcher((Matcher<? extends Number>)org.hamcrest.Matchers.is((Object)expectedStatusCode));
    }

    public static <T> Matcher<Response> header(Matcher<Map<String, T>> matcher) {
        return new ResponseHeaderMatcher<T>(matcher);
    }

    public static <T> Matcher<SAML2Object> isSamlResponse(JBossSAMLURIConstants expectedStatus) {
        return org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.instanceOf(ResponseType.class), (Matcher)new SamlResponseTypeMatcher((Matcher<URI>)org.hamcrest.Matchers.is((Object)expectedStatus.getUri())));
    }

    public static <T> Matcher<SAML2Object> isSamlLogoutRequest(String destination) {
        return org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.instanceOf(LogoutRequestType.class), (Matcher)new SamlLogoutRequestTypeMatcher(URI.create(destination)));
    }

    public static <T> Matcher<SAML2Object> isSamlAuthnRequest() {
        return org.hamcrest.Matchers.instanceOf(AuthnRequestType.class);
    }

    public static <T> Matcher<SAML2Object> isSamlStatusResponse(JBossSAMLURIConstants ... expectedStatus) {
        return org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.instanceOf(StatusResponseType.class), (Matcher)new SamlStatusResponseTypeMatcher((URI[])Arrays.stream(expectedStatus).map(JBossSAMLURIConstants::getUri).toArray(URI[]::new)));
    }
}

