/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;

public class MailUtils {
    private static Pattern mailPattern = Pattern.compile("http[^\\s\"]*");

    public static String getLink(String body) {
        Matcher matcher = mailPattern.matcher(body);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new AssertionError((Object)("No link found in " + body));
    }

    public static String getPasswordResetEmailLink(MimeMessage message) throws IOException {
        return MailUtils.getPasswordResetEmailLink(new EmailBody(message));
    }

    public static String getRecipient(MimeMessage message) throws MessagingException {
        Address[] recipients = message.getRecipients(MimeMessage.RecipientType.TO);
        return recipients[0].toString();
    }

    public static String getPasswordResetEmailLink(EmailBody body) throws IOException {
        String textChangePwdUrl = MailUtils.getLink(body.getText());
        String htmlChangePwdUrl = MailUtils.getLink(body.getHtml());
        Assert.assertEquals((Object)htmlChangePwdUrl, (Object)textChangePwdUrl);
        return htmlChangePwdUrl;
    }

    public static EmailBody getBody(MimeMessage message) throws IOException {
        return new EmailBody(message);
    }

    public static class EmailBody {
        private String text;
        private String html;

        private EmailBody(MimeMessage message) throws IOException {
            try {
                Multipart multipart = (Multipart)message.getContent();
                String textContentType = multipart.getBodyPart(0).getContentType();
                Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)textContentType);
                this.text = (String)multipart.getBodyPart(0).getContent();
                String htmlContentType = multipart.getBodyPart(1).getContentType();
                Assert.assertEquals((Object)"text/html; charset=UTF-8", (Object)htmlContentType);
                this.html = (String)multipart.getBodyPart(1).getContent();
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        }

        public String getText() {
            return this.text;
        }

        public String getHtml() {
            return this.html;
        }
    }
}

