/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.keycloak.testsuite.util.TextFileChecker;

public class LogChecker {
    public static String[] getJBossServerLogFiles(String jbossHome) {
        boolean domain = System.getProperty("auth.server.config.property.name", "standalone").contains("domain");
        if (domain) {
            return new String[]{jbossHome + "/domain/log/process-controller.log", jbossHome + "/domain/log/host-controller.log", jbossHome + "/domain/servers/load-balancer/log/server.log", jbossHome + "/domain/servers/server-one/log/server.log"};
        }
        return new String[]{jbossHome + "/standalone/log/server.log"};
    }

    public static TextFileChecker getJBossServerLogsChecker(String jbossHome) throws IOException {
        String[] pathsToCheck = LogChecker.getJBossServerLogFiles(jbossHome);
        Path[] pathsArray = (Path[])Arrays.stream(pathsToCheck).map(File::new).map(File::toPath).toArray(Path[]::new);
        return new TextFileChecker(pathsArray);
    }
}

