/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.junit.Assume;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.keycloak.testsuite.util.LDAPTestConfiguration;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.keycloak.util.ldap.LDAPEmbeddedServer;

public class LDAPRule
extends ExternalResource {
    private static final Logger log = Logger.getLogger(LDAPRule.class);
    private static final String VAULT_EXPRESSION = "${vault.ldap_bindCredential}";
    public static final String LDAP_CONNECTION_PROPERTIES_LOCATION = "classpath:ldap/ldap-connection.properties";
    private static final String PROPERTY_ENABLE_ACCESS_CONTROL = "enableAccessControl";
    private static final String PROPERTY_ENABLE_ANONYMOUS_ACCESS = "enableAnonymousAccess";
    private static final String PROPERTY_ENABLE_SSL = "enableSSL";
    private static final String PROPERTY_ENABLE_STARTTLS = "enableStartTLS";
    private static final String PROPERTY_KEYSTORE_FILE = "keystoreFile";
    private static final String PRIVATE_KEY = "dependency/keystore/keycloak.jks";
    private static final String PROPERTY_CERTIFICATE_PASSWORD = "certificatePassword";
    LDAPTestConfiguration ldapTestConfiguration;
    private LDAPEmbeddedServer ldapEmbeddedServer;
    private LDAPAssume assume;
    protected Properties defaultProperties = new Properties();

    public LDAPRule assumeTrue(LDAPAssume assume) {
        this.assume = assume;
        return this;
    }

    protected void before() throws Throwable {
        String connectionPropsLocation = this.getConnectionPropertiesLocation();
        this.ldapTestConfiguration = LDAPTestConfiguration.readConfiguration(connectionPropsLocation);
        Assume.assumeTrue((String)"Assumption in LDAPRule is false. Skiping the test", (this.assume == null || this.assume.assumeTrue(this.ldapTestConfiguration) ? 1 : 0) != 0);
        if (this.ldapTestConfiguration.isStartEmbeddedLdapServer()) {
            this.ldapEmbeddedServer = this.createServer();
            this.ldapEmbeddedServer.init();
            this.ldapEmbeddedServer.start();
        }
    }

    public Statement apply(Statement base, Description description) {
        this.defaultProperties.setProperty("bindCredential", "secret");
        this.defaultProperties.setProperty(PROPERTY_ENABLE_ACCESS_CONTROL, "true");
        this.defaultProperties.setProperty(PROPERTY_ENABLE_ANONYMOUS_ACCESS, "false");
        this.defaultProperties.setProperty(PROPERTY_ENABLE_SSL, "true");
        this.defaultProperties.setProperty(PROPERTY_ENABLE_STARTTLS, "false");
        this.defaultProperties.setProperty("setConfidentialityRequired", "false");
        this.defaultProperties.setProperty("AUTO_UPDATE_LDAP_CONNECTION_URL", "false");
        Annotation ldapConnectionAnnotation = description.getAnnotation(LDAPConnectionParameters.class);
        if (ldapConnectionAnnotation != null) {
            this.defaultProperties.setProperty("AUTO_UPDATE_LDAP_CONNECTION_URL", "true");
            LDAPConnectionParameters connectionParameters = (LDAPConnectionParameters)ldapConnectionAnnotation;
            switch (connectionParameters.bindCredential()) {
                case SECRET: {
                    log.debug((Object)"Setting bind credential to secret.");
                    this.defaultProperties.setProperty("bindCredential", "secret");
                    break;
                }
                case VAULT: {
                    log.debug((Object)"Setting bind credential to vault.");
                    this.defaultProperties.setProperty("bindCredential", VAULT_EXPRESSION);
                }
            }
            switch (connectionParameters.bindType()) {
                case NONE: {
                    log.debug((Object)"Enabling anonymous authentication method on the LDAP server.");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_ANONYMOUS_ACCESS, "true");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_ACCESS_CONTROL, "false");
                    break;
                }
                case SIMPLE: {
                    log.debug((Object)"Disabling anonymous authentication method on the LDAP server.");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_ANONYMOUS_ACCESS, "false");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_ACCESS_CONTROL, "true");
                }
            }
            switch (connectionParameters.encryption()) {
                case NONE: {
                    log.debug((Object)"Disabling connection encryption on the LDAP server.");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_SSL, "false");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_STARTTLS, "false");
                    break;
                }
                case SSL: {
                    log.debug((Object)"Enabling SSL connection encryption on the LDAP server.");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_SSL, "true");
                    log.debug((Object)"Configuring the LDAP server to accepts only requests with a secured connection.");
                    this.defaultProperties.setProperty("setConfidentialityRequired", "true");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_STARTTLS, "false");
                    break;
                }
                case STARTTLS: {
                    log.debug((Object)"Enabling StartTLS connection encryption on the LDAP server.");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_STARTTLS, "true");
                    log.debug((Object)"Configuring the LDAP server to accepts only requests with a secured connection.");
                    this.defaultProperties.setProperty("setConfidentialityRequired", "true");
                    this.defaultProperties.setProperty(PROPERTY_ENABLE_SSL, "false");
                }
            }
        }
        return super.apply(base, description);
    }

    protected void after() {
        try {
            if (this.ldapEmbeddedServer != null) {
                this.ldapEmbeddedServer.stop();
                this.ldapEmbeddedServer = null;
                this.ldapTestConfiguration = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error tearDown Embedded LDAP server.", e);
        }
    }

    protected String getConnectionPropertiesLocation() {
        return LDAP_CONNECTION_PROPERTIES_LOCATION;
    }

    protected LDAPEmbeddedServer createServer() {
        this.defaultProperties.setProperty("ldap.dsf", "mem");
        this.defaultProperties.setProperty("ldap.ldif", "classpath:ldap/users.ldif");
        this.defaultProperties.setProperty(PROPERTY_CERTIFICATE_PASSWORD, "secret");
        this.defaultProperties.setProperty(PROPERTY_KEYSTORE_FILE, new File(IOUtil.PROJECT_BUILD_DIRECTORY, PRIVATE_KEY).getAbsolutePath());
        return new LDAPEmbeddedServer(this.defaultProperties);
    }

    public Map<String, String> getConfig() {
        Map<String, String> config = this.ldapTestConfiguration.getLDAPConfig();
        String ldapConnectionUrl = config.get("connectionUrl");
        if (ldapConnectionUrl != null && this.defaultProperties.getProperty("AUTO_UPDATE_LDAP_CONNECTION_URL").equals("true")) {
            String updatedUrl;
            if (ldapConnectionUrl.startsWith("ldap://") && this.defaultProperties.getProperty(PROPERTY_ENABLE_SSL).equals("true")) {
                updatedUrl = ldapConnectionUrl.replaceAll("ldap://", "ldaps://");
                updatedUrl = updatedUrl.replaceAll(String.valueOf(this.ldapEmbeddedServer.getBindPort()), String.valueOf(this.ldapEmbeddedServer.getBindLdapsPort()));
                config.put("connectionUrl", updatedUrl);
                log.debugf("Using LDAP over SSL \"%s\" connection URL form over: \"%s\" since SSL connection was requested.", (Object)updatedUrl, (Object)ldapConnectionUrl);
            }
            if (ldapConnectionUrl.startsWith("ldaps://") && !this.defaultProperties.getProperty(PROPERTY_ENABLE_SSL).equals("true")) {
                updatedUrl = ldapConnectionUrl.replaceAll("ldaps://", "ldap://");
                updatedUrl = updatedUrl.replaceAll(String.valueOf(this.ldapEmbeddedServer.getBindLdapsPort()), String.valueOf(this.ldapEmbeddedServer.getBindPort()));
                config.put("connectionUrl", updatedUrl);
                log.debugf("Using plaintext / startTLS \"%s\" connection URL form over: \"%s\" since plaintext / startTLS connection was requested.", (Object)updatedUrl, (Object)ldapConnectionUrl);
            }
        }
        switch (this.defaultProperties.getProperty("bindCredential")) {
            case "${vault.ldap_bindCredential}": {
                config.put("bindCredential", VAULT_EXPRESSION);
            }
        }
        switch (this.defaultProperties.getProperty(PROPERTY_ENABLE_ANONYMOUS_ACCESS)) {
            case "true": {
                config.put("authType", "none");
                break;
            }
            default: {
                config.put("authType", "simple");
            }
        }
        switch (this.defaultProperties.getProperty(PROPERTY_ENABLE_STARTTLS)) {
            case "true": {
                config.put("startTls", "true");
                config.put("useTruststoreSpi", "always");
                break;
            }
            default: {
                config.put("startTls", "false");
                config.put("useTruststoreSpi", "ldapsOnly");
            }
        }
        switch (this.defaultProperties.getProperty("setConfidentialityRequired")) {
            case "true": {
                System.setProperty("PROPERTY_SET_CONFIDENTIALITY_REQUIRED", "true");
                break;
            }
            default: {
                System.setProperty("PROPERTY_SET_CONFIDENTIALITY_REQUIRED", "false");
            }
        }
        return config;
    }

    public int getSleepTime() {
        return this.ldapTestConfiguration.getSleepTime();
    }

    public LDAPEmbeddedServer getLdapEmbeddedServer() {
        return this.ldapEmbeddedServer;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface LDAPConnectionParameters {
        public BindCredential bindCredential() default BindCredential.SECRET;

        public BindType bindType() default BindType.SIMPLE;

        public Encryption encryption() default Encryption.SSL;

        public static enum Encryption {
            NONE,
            SSL,
            STARTTLS;

        }

        public static enum BindType {
            NONE,
            SIMPLE;

        }

        public static enum BindCredential {
            SECRET,
            VAULT;

        }
    }

    public static interface LDAPAssume {
        public boolean assumeTrue(LDAPTestConfiguration var1);
    }
}

