/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.WebDriver;

public final class DroneUtils {
    private static Queue<WebDriver> driverQueue = new LinkedList<WebDriver>();

    public static WebDriver getCurrentDriver() {
        if (driverQueue.isEmpty()) {
            return GrapheneContext.lastContext().getWebDriver(new Class[0]);
        }
        return driverQueue.peek();
    }

    public static void addWebDriver(WebDriver driver) {
        driverQueue.add(driver);
    }

    public static void removeWebDriver() {
        driverQueue.poll();
    }

    public static void resetQueue() {
        driverQueue = new LinkedList<WebDriver>();
    }

    public static void replaceDefaultWebDriver(Object target, WebDriver driver) {
        DroneUtils.addWebDriver(driver);
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> targetClass = target.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
            allFields.addAll(Arrays.asList(targetClass.getDeclaredFields()));
            allFields.addAll(Arrays.asList(targetClass.getFields()));
        }
        for (Field f : allFields) {
            Object o;
            if (f.getAnnotation(Page.class) != null && AbstractPage.class.isAssignableFrom(f.getType())) {
                try {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    o = f.get(target);
                    AbstractPage page = (AbstractPage)o;
                    page.setDriver(driver);
                    DroneUtils.replaceDefaultWebDriver(page, driver);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Could not replace the driver in " + f, e);
                }
            }
            if (f.getName().equals("driver") && WebDriver.class.isAssignableFrom(f.getType())) {
                try {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    f.set(target, driver);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Could not replace the " + f.getName() + " in class " + target.getClass().getName(), e);
                }
            }
            if (!f.getName().equals("oauth") || !OAuthClient.class.isAssignableFrom(f.getType())) continue;
            try {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                o = f.get(target);
                ((OAuthClient)o).setDriver(driver);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not replace the " + f.getName() + " in class " + target.getClass().getName(), e);
            }
        }
        DroneUtils.removeWebDriver();
    }
}

