/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResolveType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResponseType;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.profile.util.Soap;
import org.keycloak.saml.SAML2NameIDBuilder;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.w3c.dom.Document;

@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class ArtifactResolutionService
implements Provider<Source>,
Runnable {
    private ArtifactResponseType artifactResponseType;
    private final String endpointAddress;
    private ArtifactResolveType lastArtifactResolve;
    private boolean running = true;

    public ArtifactResolutionService(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public ArtifactResolutionService setResponseDocument(Document responseDocument) {
        try {
            this.artifactResponseType = SamlProtocolUtils.buildArtifactResponse((Document)responseDocument);
        }
        catch (ConfigurationException | ParsingException | ProcessingException e) {
            e.printStackTrace();
        }
        return this;
    }

    public ArtifactResolutionService setEmptyArtifactResponse(String issuer) {
        try {
            this.artifactResponseType = SamlProtocolUtils.buildArtifactResponse(null, (NameIDType)SAML2NameIDBuilder.value((String)issuer).build());
        }
        catch (ConfigurationException | ProcessingException e) {
            e.printStackTrace();
        }
        return this;
    }

    public ArtifactResolveType getLastArtifactResolve() {
        return this.lastArtifactResolve;
    }

    public Source invoke(Source msg) {
        byte[] response;
        try (StringWriter w = new StringWriter();){
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(msg, new StreamResult(w));
            String s = w.toString();
            Document doc = Soap.extractSoapMessage((InputStream)new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)));
            SAMLDocumentHolder samlDoc = SAML2Request.getSAML2ObjectFromDocument((Document)doc);
            this.lastArtifactResolve = samlDoc.getSamlObject() instanceof ArtifactResolveType ? (ArtifactResolveType)samlDoc.getSamlObject() : null;
            Document artifactResponse = SamlProtocolUtils.convert((ArtifactResponseType)this.artifactResponseType);
            response = Soap.createMessage().addToBody(artifactResponse).getBytes();
        }
        catch (IOException | TransformerException | ConfigurationException | ParsingException | ProcessingException e) {
            throw new RuntimeException(e);
        }
        return new StreamSource(new ByteArrayInputStream(response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Endpoint endpoint;
        ArtifactResolutionService artifactResolutionService = this;
        synchronized (artifactResolutionService) {
            endpoint = Endpoint.create((String)"http://www.w3.org/2004/08/wsdl/http", (Object)this);
            endpoint.publish(this.endpointAddress);
            this.notify();
        }
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        endpoint.stop();
    }

    public void stop() {
        this.running = false;
    }
}

