/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngineBuilder43;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.utils.io.IOUtil;

public class AdminClientUtil {
    public static final int NUMBER_OF_CONNECTIONS = 10;

    public static Keycloak createAdminClient(boolean ignoreUnknownProperties, String authServerContextRoot) throws Exception {
        return AdminClientUtil.createAdminClient(ignoreUnknownProperties, authServerContextRoot, "master", "admin", "admin", "admin-cli", null);
    }

    public static Keycloak createAdminClient(boolean ignoreUnknownProperties, String realmName, String username, String password, String clientId, String clientSecret) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        return AdminClientUtil.createAdminClient(ignoreUnknownProperties, ServerURLs.getAuthServerContextRoot(), realmName, username, password, clientId, clientSecret);
    }

    public static Keycloak createAdminClient(boolean ignoreUnknownProperties, String authServerContextRoot, String realmName, String username, String password, String clientId, String clientSecret) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        ResteasyClient resteasyClient = AdminClientUtil.createResteasyClient(ignoreUnknownProperties, null);
        return KeycloakBuilder.builder().serverUrl(authServerContextRoot + "/auth").realm(realmName).username(username).password(password).clientId(clientId).clientSecret(clientSecret).resteasyClient(resteasyClient).build();
    }

    public static Keycloak createAdminClientWithClientCredentials(String realmName, String clientId, String clientSecret) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        boolean ignoreUnknownProperties = false;
        ResteasyClient resteasyClient = AdminClientUtil.createResteasyClient(ignoreUnknownProperties, null);
        return KeycloakBuilder.builder().serverUrl(ServerURLs.getAuthServerContextRoot() + "/auth").realm(realmName).grantType("client_credentials").clientId(clientId).clientSecret(clientSecret).resteasyClient(resteasyClient).build();
    }

    public static Keycloak createAdminClient() throws Exception {
        return AdminClientUtil.createAdminClient(false, ServerURLs.getAuthServerContextRoot());
    }

    public static Keycloak createAdminClient(boolean ignoreUnknownProperties) throws Exception {
        return AdminClientUtil.createAdminClient(ignoreUnknownProperties, ServerURLs.getAuthServerContextRoot());
    }

    public static ResteasyClient createResteasyClient() {
        try {
            return AdminClientUtil.createResteasyClient(false, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ResteasyClient createResteasyClient(boolean ignoreUnknownProperties, Boolean followRedirects) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        ResteasyClientBuilder resteasyClientBuilder = new ResteasyClientBuilder();
        if ("true".equals(System.getProperty("auth.server.ssl.required"))) {
            File trustore = new File(IOUtil.PROJECT_BUILD_DIRECTORY, "dependency/keystore/keycloak.truststore");
            resteasyClientBuilder.sslContext(AdminClientUtil.getSSLContextWithTrustore(trustore, "secret"));
            System.setProperty("javax.net.ssl.trustStore", trustore.getAbsolutePath());
        }
        if (ignoreUnknownProperties) {
            ResteasyJackson2Provider jacksonProvider = new ResteasyJackson2Provider(){};
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            jacksonProvider.setMapper(objectMapper);
            resteasyClientBuilder.register((Object)jacksonProvider, 100);
        }
        resteasyClientBuilder.hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.WILDCARD).connectionPoolSize(10).httpEngine(AdminClientUtil.getCustomClientHttpEngine(resteasyClientBuilder, 1, followRedirects));
        return resteasyClientBuilder.build();
    }

    private static SSLContext getSSLContextWithTrustore(File file, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        if (!file.isFile()) {
            throw new RuntimeException("Truststore file not found: " + file.getAbsolutePath());
        }
        SSLContext theContext = SSLContexts.custom().useProtocol("TLS").loadTrustMaterial(file, password == null ? null : password.toCharArray()).build();
        return theContext;
    }

    public static ClientHttpEngine getCustomClientHttpEngine(ResteasyClientBuilder resteasyClientBuilder, int validateAfterInactivity, Boolean followRedirects) {
        return new CustomClientHttpEngineBuilder43(validateAfterInactivity, followRedirects).resteasyClientBuilder(resteasyClientBuilder).build();
    }

    private static class CustomClientHttpEngineBuilder43
    extends ClientHttpEngineBuilder43 {
        private final int validateAfterInactivity;
        private final Boolean followRedirects;

        private CustomClientHttpEngineBuilder43(int validateAfterInactivity, Boolean followRedirects) {
            this.validateAfterInactivity = validateAfterInactivity;
            this.followRedirects = followRedirects;
        }

        protected ClientHttpEngine createEngine(HttpClientConnectionManager cm, RequestConfig.Builder rcBuilder, HttpHost defaultProxy, int responseBufferSize, HostnameVerifier verifier, SSLContext theContext) {
            ClientHttpEngine engine;
            if (cm instanceof PoolingHttpClientConnectionManager) {
                PoolingHttpClientConnectionManager pcm = (PoolingHttpClientConnectionManager)cm;
                pcm.setValidateAfterInactivity(this.validateAfterInactivity);
                engine = super.createEngine((HttpClientConnectionManager)pcm, rcBuilder, defaultProxy, responseBufferSize, verifier, theContext);
            } else {
                engine = super.createEngine(cm, rcBuilder, defaultProxy, responseBufferSize, verifier, theContext);
            }
            if (this.followRedirects != null) {
                ((ApacheHttpClient4Engine)engine).setFollowRedirects(this.followRedirects.booleanValue());
            }
            return engine;
        }
    }
}

