/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.updaters;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class ServerResourceUpdater<T extends ServerResourceUpdater, Res, Rep>
implements Closeable {
    protected final Res resource;
    protected final Rep rep;
    protected final Rep origRep;
    protected Consumer<Rep> updater;
    protected boolean updated = false;

    public ServerResourceUpdater(Res resource, Supplier<Rep> representationGenerator, Consumer<Rep> updater) {
        this.resource = resource;
        this.updater = updater;
        this.origRep = representationGenerator.get();
        this.rep = representationGenerator.get();
    }

    public Res getResource() {
        return this.resource;
    }

    public T update() {
        this.performUpdate(this.origRep, this.rep);
        this.updated = true;
        return (T)this;
    }

    protected void performUpdate(Rep from, Rep to) {
        this.updater.accept(to);
    }

    public T updateWith(Consumer<Rep> representationUpdater) {
        representationUpdater.accept(this.rep);
        return (T)this;
    }

    @Override
    public void close() throws IOException {
        if (this.updated) {
            this.performUpdate(this.rep, this.origRep);
        }
    }

    public static <T, V> void updateViaAddRemove(Collection<T> from, Collection<T> to, Supplier<Function<T, V>> client2ServerConvertorGenerator, Consumer<V> add, Consumer<V> remove) {
        if (Objects.equals(from, to)) {
            return;
        }
        Function<T, V> client2ServerConvertor = client2ServerConvertorGenerator.get();
        Set current = from == null ? Collections.EMPTY_SET : from.stream().map(client2ServerConvertor).collect(Collectors.toSet());
        Set expected = to == null ? Collections.EMPTY_SET : to.stream().map(client2ServerConvertor).collect(Collectors.toSet());
        expected.stream().filter(role -> !current.contains(role)).forEach(add);
        current.stream().filter(role -> !expected.contains(role)).forEach(remove);
    }
}

