/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.updaters;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.admin.client.resource.RoleScopeResource;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;

public class RoleScopeUpdater
extends ServerResourceUpdater<RoleScopeUpdater, RoleScopeResource, List<RoleRepresentation>> {
    public RoleScopeUpdater(RoleScopeResource resource) {
        super(resource, () -> ((RoleScopeResource)resource).listAll(), null);
        this.updater = this::update;
    }

    public RoleScopeUpdater add(RoleRepresentation representation) {
        ((List)this.rep).add(representation);
        return this;
    }

    public RoleScopeUpdater remove(RoleRepresentation representation) {
        ((List)this.rep).remove(representation);
        return this;
    }

    public RoleScopeUpdater removeByName(String name) {
        Iterator it = ((List)this.rep).iterator();
        while (it.hasNext()) {
            RoleRepresentation mapper = (RoleRepresentation)it.next();
            if (!name.equals(mapper.getName())) continue;
            it.remove();
            break;
        }
        return this;
    }

    private void update(List<RoleRepresentation> expectedRoles) {
        List currentRoles = ((RoleScopeResource)this.resource).listAll();
        Set currentRoleIds = currentRoles.stream().map(RoleRepresentation::getId).collect(Collectors.toSet());
        Set expectedRoleIds = expectedRoles.stream().map(RoleRepresentation::getId).collect(Collectors.toSet());
        List toAdd = expectedRoles.stream().filter(role -> !currentRoleIds.contains(role.getId())).collect(Collectors.toList());
        List toRemove = currentRoles.stream().filter(role -> !expectedRoleIds.contains(role.getId())).collect(Collectors.toList());
        ((RoleScopeResource)this.resource).add(toAdd);
        ((RoleScopeResource)this.resource).remove(toRemove);
    }
}

