/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.updaters;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.representations.idm.IdentityProviderRepresentation;

public class IdentityProviderAttributeUpdater {
    private final Map<String, String> originalAttributes = new HashMap<String, String>();
    private final IdentityProviderResource identityProviderResource;
    private final IdentityProviderRepresentation rep;

    public IdentityProviderAttributeUpdater(IdentityProviderResource identityProviderResource) {
        this.identityProviderResource = identityProviderResource;
        this.rep = identityProviderResource.toRepresentation();
        if (this.rep.getConfig() == null) {
            this.rep.setConfig(new HashMap());
        }
    }

    public IdentityProviderAttributeUpdater setAttribute(String name, String value) {
        if (!this.originalAttributes.containsKey(name)) {
            this.originalAttributes.put(name, this.rep.getConfig().put(name, value));
        } else {
            this.rep.getConfig().put(name, value);
        }
        return this;
    }

    public IdentityProviderAttributeUpdater removeAttribute(String name) {
        if (!this.originalAttributes.containsKey(name)) {
            this.originalAttributes.put(name, this.rep.getConfig().put(name, null));
        } else {
            this.rep.getConfig().put(name, null);
        }
        return this;
    }

    public Closeable update() {
        this.identityProviderResource.update(this.rep);
        return () -> {
            this.rep.getConfig().putAll(this.originalAttributes);
            this.identityProviderResource.update(this.rep);
        };
    }
}

