/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.updaters;

import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.AuthenticationManagementResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.admin.client.resource.ComponentsResource;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.IdentityProvidersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;

public class Creator<T>
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(Creator.class);
    private final String id;
    private final T resource;
    private final Runnable closer;
    private final AtomicBoolean closerRan = new AtomicBoolean(false);

    public static Creator<RealmResource> create(Keycloak adminClient, RealmRepresentation rep) {
        adminClient.realms().create(rep);
        RealmResource r = adminClient.realm(rep.getRealm());
        LOG.debugf("Created realm %s", (Object)rep.getRealm());
        return new Creator<RealmResource>(rep.getRealm(), r, () -> ((RealmResource)r).remove());
    }

    public static Creator<GroupResource> create(RealmResource realmResource, GroupRepresentation rep) {
        GroupsResource groups = realmResource.groups();
        try (Response response = groups.add(rep);){
            String createdId = ApiUtil.getCreatedId(response);
            GroupResource r = groups.group(createdId);
            LOG.debugf("Created group ID %s", (Object)createdId);
            Creator<GroupResource> creator = new Creator<GroupResource>(createdId, r, () -> ((GroupResource)r).remove());
            return creator;
        }
    }

    public static Creator<ClientResource> create(RealmResource realmResource, ClientRepresentation rep) {
        ClientsResource clients = realmResource.clients();
        try (Response response = clients.create(rep);){
            String createdId = ApiUtil.getCreatedId(response);
            ClientResource r = clients.get(createdId);
            LOG.debugf("Created client ID %s", (Object)createdId);
            Creator<ClientResource> creator = new Creator<ClientResource>(createdId, r, () -> ((ClientResource)r).remove());
            return creator;
        }
    }

    public static Creator<UserResource> create(RealmResource realmResource, UserRepresentation rep) {
        UsersResource users = realmResource.users();
        try (Response response = users.create(rep);){
            String createdId = ApiUtil.getCreatedId(response);
            UserResource r = users.get(createdId);
            LOG.debugf("Created user ID %s", (Object)createdId);
            Creator<UserResource> creator = new Creator<UserResource>(createdId, r, () -> ((UserResource)r).remove());
            return creator;
        }
    }

    public static Creator<ComponentResource> create(RealmResource realmResource, ComponentRepresentation rep) {
        ComponentsResource components = realmResource.components();
        try (Response response = components.add(rep);){
            String createdId = ApiUtil.getCreatedId(response);
            ComponentResource r = components.component(createdId);
            LOG.debugf("Created component ID %s", (Object)createdId);
            Creator<ComponentResource> creator = new Creator<ComponentResource>(createdId, r, () -> ((ComponentResource)r).remove());
            return creator;
        }
    }

    public static Flow create(RealmResource realmResource, AuthenticationFlowRepresentation rep) {
        AuthenticationManagementResource authMgmgRes = realmResource.flows();
        try (Response response = authMgmgRes.createFlow(rep);){
            String createdId = ApiUtil.getCreatedId(response);
            LOG.debugf("Created flow ID %s", (Object)createdId);
            Flow flow = new Flow(createdId, rep.getAlias(), authMgmgRes, () -> authMgmgRes.deleteFlow(createdId));
            return flow;
        }
    }

    public static Creator<IdentityProviderResource> create(RealmResource realmResource, IdentityProviderRepresentation rep) {
        IdentityProvidersResource res = realmResource.identityProviders();
        Assert.assertThat((String)"Identity provider alias must be specified", (Object)rep.getAlias(), (Matcher)Matchers.notNullValue());
        try (Response response = res.create(rep);){
            String createdId = ApiUtil.getCreatedId(response);
            IdentityProviderResource r = res.get(rep.getAlias());
            LOG.debugf("Created identity provider ID %s", (Object)createdId);
            Creator<IdentityProviderResource> creator = new Creator<IdentityProviderResource>(createdId, r, () -> ((IdentityProviderResource)r).remove());
            return creator;
        }
    }

    private Creator(String id, T resource, Runnable closer) {
        this.id = id;
        this.resource = resource;
        this.closer = closer;
    }

    public String id() {
        return this.id;
    }

    public T resource() {
        return this.resource;
    }

    @Override
    public void close() {
        if (this.closerRan.compareAndSet(false, true)) {
            LOG.debugf("Removing resource ID %s", (Object)this.id);
            try {
                this.closer.run();
            }
            catch (NotFoundException ex) {
                LOG.debugf("Resource with ID %s perhaps removed in meantime.", (Object)this.id);
            }
        } else {
            LOG.debugf("Already removed resource ID %s", (Object)this.id);
        }
    }

    public static class Flow
    extends Creator<AuthenticationManagementResource> {
        private final String alias;

        public Flow(String id, String alias, AuthenticationManagementResource resource, Runnable closer) {
            super(id, resource, closer);
            this.alias = alias;
        }

        public AuthenticationExecutionInfoRepresentation addExecution(String providerId) {
            HashMap<String, String> c = new HashMap<String, String>();
            c.put("provider", providerId);
            ((AuthenticationManagementResource)this.resource()).addExecution(this.alias, c);
            return ((AuthenticationManagementResource)this.resource()).getExecutions(this.alias).stream().filter(aer -> Objects.equals(providerId, aer.getProviderId())).findFirst().orElse(null);
        }
    }
}

