/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages.x509;

import org.jboss.arquillian.test.api.ArquillianResource;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class X509IdentityConfirmationPage
extends LanguageComboboxAwarePage {
    @ArquillianResource
    protected OAuthClient oauth;
    @FindBy(id="username")
    private WebElement usernameText;
    @FindBy(name="login")
    private WebElement confirmButton;
    @FindBy(name="cancel")
    private WebElement ignoreButton;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;
    @FindBy(className="alert-warning")
    private WebElement loginWarningMessage;
    @FindBy(className="alert-success")
    private WebElement loginSuccessMessage;
    @FindBy(className="alert-info")
    private WebElement loginInfoMessage;
    @FindBy(id="counter")
    private WebElement loginDelayCounter;
    @FindBy(id="certificate_subjectDN")
    private WebElement certificateSubjectDistinguishedName;

    public void confirm() {
        this.confirmButton.click();
    }

    public String getLoginDelayCounterText() {
        return this.loginDelayCounter.getText();
    }

    public String getSubjectDistinguishedNameText() {
        return this.certificateSubjectDistinguishedName.getText();
    }

    public String getUsernameText() {
        return this.usernameText.getText();
    }

    public void ignore() {
        this.ignoreButton.click();
    }

    public String getError() {
        return this.loginErrorMessage != null ? this.loginErrorMessage.getText() : null;
    }

    @Override
    public boolean isCurrent() {
        return this.driver.getTitle().equals("Sign in to test") || this.driver.getTitle().equals("Anmeldung bei test");
    }

    @Override
    public void open() {
        this.oauth.openLoginForm();
        this.assertCurrent();
    }
}

