/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages.social;

import java.util.List;
import org.keycloak.testsuite.pages.social.AbstractSocialLoginPage;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class GoogleLoginPage
extends AbstractSocialLoginPage {
    @FindBy(id="identifierId")
    private WebElement emailInput;
    @FindBy(xpath=".//input[@type='password']")
    private WebElement passwordInput;
    @FindBy(xpath="//form//ul/li/div[@role='link']")
    private List<WebElement> selectAccountLinks;

    @Override
    public void login(String user, String password) {
        if (this.selectAccountLinks.size() > 1) {
            UIUtils.clickLink(this.selectAccountLinks.get(this.selectAccountLinks.size() - 1));
        }
        this.emailInput.clear();
        this.emailInput.sendKeys(new CharSequence[]{user});
        this.emailInput.sendKeys(new CharSequence[]{Keys.RETURN});
        WaitUtils.pause(3000L);
        this.passwordInput.sendKeys(new CharSequence[]{password});
        this.passwordInput.sendKeys(new CharSequence[]{Keys.RETURN});
    }

    @Override
    public void logout() {
        this.log.info((Object)"performing logout from Google");
        URLUtils.navigateToUri("https://www.google.com/accounts/Logout");
    }
}

