/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.jboss.arquillian.graphene.page.Page;
import org.keycloak.testsuite.auth.page.AccountFields;
import org.keycloak.testsuite.pages.AbstractPage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class VerifyProfilePage
extends AbstractPage {
    @Page
    private AccountFields.AccountErrors accountErrors;
    @FindBy(id="firstName")
    private WebElement firstNameInput;
    @FindBy(id="lastName")
    private WebElement lastNameInput;
    @FindBy(id="email")
    private WebElement emailInput;
    @FindBy(id="department")
    private WebElement departmentInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-error")
    private WebElement loginAlertErrorMessage;

    public void update(String firstName, String lastName) {
        this.firstNameInput.clear();
        if (firstName != null) {
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        this.lastNameInput.clear();
        if (lastName != null) {
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        this.submitButton.click();
    }

    public void update(String firstName, String lastName, String department) {
        this.departmentInput.clear();
        if (department != null) {
            this.departmentInput.sendKeys(new CharSequence[]{department});
        }
        this.update(firstName, lastName);
    }

    public void updateEmail(String email, String firstName, String lastName) {
        this.emailInput.clear();
        if (this.emailInput != null) {
            this.emailInput.sendKeys(new CharSequence[]{email});
        }
        this.firstNameInput.clear();
        if (firstName != null) {
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        this.lastNameInput.clear();
        if (lastName != null) {
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        this.submitButton.click();
    }

    public String getAlertError() {
        try {
            return UIUtils.getTextFromElement(this.loginAlertErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getLabelForField(String fieldId) {
        return this.driver.findElement(By.cssSelector((String)("label[for=" + fieldId + "]"))).getText();
    }

    public String getFirstName() {
        return this.firstNameInput.getAttribute("value");
    }

    public String getLastName() {
        return this.lastNameInput.getAttribute("value");
    }

    public String getDepartment() {
        return this.departmentInput.getAttribute("value");
    }

    public boolean isDepartmentEnabled() {
        return this.departmentInput.isEnabled();
    }

    public boolean isUsernamePresent() {
        try {
            return this.driver.findElement(By.id((String)"username")).isDisplayed();
        }
        catch (NoSuchElementException nse) {
            return false;
        }
    }

    public boolean isDepartmentPresent() {
        try {
            this.isDepartmentEnabled();
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public String getEmail() {
        return this.emailInput.getAttribute("value");
    }

    @Override
    public boolean isCurrent() {
        return PageUtils.getPageTitle(this.driver).equals("Update Account Information");
    }

    public AccountFields.AccountErrors getInputAccountErrors() {
        return this.accountErrors;
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }
}

