/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.util.DroneUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class SelectAuthenticatorPage
extends LanguageComboboxAwarePage {
    public static final String PASSWORD = "Password";
    public static final String AUTHENTICATOR_APPLICATION = "Authenticator Application";
    public static final String SECURITY_KEY = "Security Key";

    public List<String> getAvailableLoginMethods() {
        List<WebElement> rows = this.getLoginMethodsRows();
        return rows.stream().map(this::getLoginMethodNameFromRow).collect(Collectors.toList());
    }

    public void selectLoginMethod(String loginMethodName) {
        this.getLoginMethodRowByName(loginMethodName).click();
    }

    public String getLoginMethodHelpText(String loginMethodName) {
        return this.getLoginMethodRowByName(loginMethodName).findElement(By.className((String)"select-auth-box-desc")).getText();
    }

    private List<WebElement> getLoginMethodsRows() {
        return this.driver.findElements(By.className((String)"select-auth-box-parent"));
    }

    private String getLoginMethodNameFromRow(WebElement loginMethodRow) {
        return loginMethodRow.findElement(By.className((String)"select-auth-box-headline")).getText();
    }

    private WebElement getLoginMethodRowByName(String loginMethodName) {
        return this.getLoginMethodsRows().stream().filter(loginMethodRow -> loginMethodName.equals(this.getLoginMethodNameFromRow((WebElement)loginMethodRow))).findFirst().orElseThrow(() -> new AssertionError((Object)("Login method '" + loginMethodName + "' not found in the available authentication mechanisms")));
    }

    @Override
    public boolean isCurrent() {
        if (!DroneUtils.getCurrentDriver().getTitle().startsWith("Sign in to ") && !DroneUtils.getCurrentDriver().getTitle().startsWith("Anmeldung bei ")) {
            return false;
        }
        try {
            this.driver.findElement(By.id((String)"kc-select-credential-form"));
        }
        catch (NoSuchElementException nfe) {
            return false;
        }
        return true;
    }

    @Override
    public void open() throws Exception {
        throw new UnsupportedOperationException();
    }
}

