/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class OAuthGrantPage
extends LanguageComboboxAwarePage {
    public static final String PROFILE_CONSENT_TEXT = "User profile";
    public static final String EMAIL_CONSENT_TEXT = "Email address";
    public static final String ADDRESS_CONSENT_TEXT = "Address";
    public static final String PHONE_CONSENT_TEXT = "Phone number";
    public static final String OFFLINE_ACCESS_CONSENT_TEXT = "Offline Access";
    public static final String ROLES_CONSENT_TEXT = "User roles";
    @FindBy(css="input[name=\"accept\"]")
    private WebElement acceptButton;
    @FindBy(css="input[name=\"cancel\"]")
    private WebElement cancelButton;

    public void accept() {
        UIUtils.clickLink(this.acceptButton);
    }

    public void cancel() {
        UIUtils.clickLink(this.cancelButton);
    }

    @Override
    public boolean isCurrent() {
        return PageUtils.getPageTitle(this.driver).contains("Grant Access to ");
    }

    @Override
    public void open() {
    }

    public List<String> getDisplayedGrants() {
        LinkedList<String> table = new LinkedList<String>();
        WebElement divKcOauth = this.driver.findElement(By.id((String)"kc-oauth"));
        for (WebElement li : divKcOauth.findElements(By.tagName((String)"li"))) {
            WebElement span = li.findElement(By.tagName((String)"span"));
            table.add(span.getText());
        }
        return table;
    }

    public void assertGrants(String ... expectedGrants) {
        List<String> displayed = this.getDisplayedGrants();
        List<String> expected = Arrays.asList(expectedGrants);
        Assert.assertTrue((String)("Not matched grants. Displayed grants: " + displayed + ", expected grants: " + expected), (displayed.containsAll(expected) && expected.containsAll(displayed) ? 1 : 0) != 0);
    }
}

