/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.keycloak.common.util.Retry;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginTotpPage
extends LanguageComboboxAwarePage {
    @FindBy(id="otp")
    private WebElement otpInput;
    @FindBy(id="password-token")
    private WebElement passwordToken;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;
    @FindBy(id="input-error-otp-code")
    private WebElement totpInputCodeError;

    public void login(String totp) {
        this.otpInput.clear();
        if (totp != null) {
            this.otpInput.sendKeys(new CharSequence[]{totp});
        }
        this.submitButton.click();
    }

    public String getAlertError() {
        try {
            return UIUtils.getTextFromElement(this.loginErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getInputError() {
        try {
            return UIUtils.getTextFromElement(this.totpInputCodeError);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public boolean isCurrent() {
        try {
            this.driver.findElement(By.id((String)"otp"));
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }

    public void assertOtpCredentialSelectorAvailability(boolean expectedAvailability) {
        try {
            this.driver.findElement(By.className((String)"pf-c-tile"));
            Assert.assertTrue((boolean)expectedAvailability);
        }
        catch (NoSuchElementException nse) {
            Assert.assertFalse((boolean)expectedAvailability);
        }
    }

    public List<String> getAvailableOtpCredentials() {
        return this.driver.findElements(this.getXPathForLookupAllCards()).stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public String getSelectedOtpCredential() {
        try {
            WebElement selected = this.driver.findElement(this.getCssSelectorForLookupActiveCard());
            return selected.getText();
        }
        catch (NoSuchElementException nse) {
            return null;
        }
    }

    private By getXPathForLookupAllCards() {
        return By.xpath((String)"//span[contains(@class, 'pf-c-tile__title')]");
    }

    private By getCssSelectorForLookupActiveCard() {
        return By.cssSelector((String)".pf-c-tile__input:checked + .pf-c-tile .pf-c-tile__title");
    }

    private By getXPathForLookupCardWithName(String credentialName) {
        return By.xpath((String)("//label[contains(@class, 'pf-c-tile')][normalize-space() = '" + credentialName + "']"));
    }

    public void selectOtpCredential(String credentialName) {
        this.waitForElement(this.getCssSelectorForLookupActiveCard());
        WebElement webElement = this.driver.findElement(this.getXPathForLookupCardWithName(credentialName));
        UIUtils.clickLink(webElement);
    }

    private void waitForElement(By by) {
        Retry.executeWithBackoff(currentCount -> this.driver.findElement(by), (int)10, (int)10);
    }
}

