/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.junit.Assert;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPasswordUpdatePage
extends LanguageComboboxAwarePage {
    @FindBy(id="password-new")
    private WebElement newPasswordInput;
    @FindBy(id="password-confirm")
    private WebElement passwordConfirmInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;
    @FindBy(className="kc-feedback-text")
    private WebElement feedbackMessage;
    @FindBy(id="logout-sessions")
    private WebElement logoutSessionsCheckbox;
    @FindBy(name="cancel-aia")
    private WebElement cancelAIAButton;

    public void changePassword(String newPassword, String passwordConfirm) {
        this.newPasswordInput.sendKeys(new CharSequence[]{newPassword});
        this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        this.submitButton.click();
    }

    public void cancel() {
        this.cancelAIAButton.click();
    }

    @Override
    public boolean isCurrent() {
        return PageUtils.getPageTitle(this.driver).equals("Update password");
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }

    public String getError() {
        return this.loginErrorMessage != null ? this.loginErrorMessage.getText() : null;
    }

    public String getFeedbackMessage() {
        return this.feedbackMessage.getText();
    }

    public boolean isLogoutSessionDisplayed() {
        return UIUtils.isElementVisible(this.logoutSessionsCheckbox);
    }

    public boolean isLogoutSessionsChecked() {
        return this.logoutSessionsCheckbox.isSelected();
    }

    public void checkLogoutSessions() {
        Assert.assertFalse((String)"Logout sessions is checked", (boolean)this.isLogoutSessionsChecked());
        this.logoutSessionsCheckbox.click();
    }

    public void uncheckLogoutSessions() {
        Assert.assertTrue((String)"Logout sessions is not checked", (boolean)this.isLogoutSessionsChecked());
        this.logoutSessionsCheckbox.click();
    }

    public boolean isCancelDisplayed() {
        return UIUtils.isElementVisible(this.cancelAIAButton);
    }
}

