/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPasswordResetPage
extends LanguageComboboxAwarePage {
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="input-error-username")
    private WebElement usernameError;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(className="alert-success")
    private WebElement emailSuccessMessage;
    @FindBy(className="alert-error")
    private WebElement emailErrorMessage;
    @FindBy(partialLinkText="Back to Login")
    private WebElement backToLogin;
    @FindBy(id="kc-info-wrapper")
    private WebElement infoWrapper;

    public void changePassword() {
        this.submitButton.click();
    }

    public void changePassword(String username) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.submitButton.click();
    }

    @Override
    public boolean isCurrent() {
        return PageUtils.getPageTitle(this.driver).equals("Forgot Your Password?");
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }

    public String getSuccessMessage() {
        return this.emailSuccessMessage != null ? this.emailSuccessMessage.getText() : null;
    }

    public String getUsernameError() {
        try {
            return UIUtils.getTextFromElement(this.usernameError);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getErrorMessage() {
        try {
            return UIUtils.getTextFromElement(this.emailErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public void backToLogin() {
        this.backToLogin.click();
    }

    public String getInfoMessage() {
        try {
            return UIUtils.getTextFromElement(this.infoWrapper);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

