/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPage
extends LanguageComboboxAwarePage {
    @ArquillianResource
    protected OAuthClient oauth;
    @FindBy(id="username")
    protected WebElement usernameInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(id="input-error")
    private WebElement inputError;
    @FindBy(id="totp")
    private WebElement totp;
    @FindBy(id="rememberMe")
    private WebElement rememberMe;
    @FindBy(name="login")
    protected WebElement submitButton;
    @FindBy(name="cancel")
    private WebElement cancelButton;
    @FindBy(linkText="Register")
    private WebElement registerLink;
    @FindBy(linkText="Forgot Password?")
    private WebElement resetPasswordLink;
    @FindBy(linkText="Username")
    private WebElement recoverUsernameLink;
    @FindBy(className="alert-error")
    private WebElement loginErrorMessage;
    @FindBy(className="alert-warning")
    private WebElement loginWarningMessage;
    @FindBy(className="alert-success")
    private WebElement loginSuccessMessage;
    @FindBy(className="alert-info")
    private WebElement loginInfoMessage;
    @FindBy(className="instruction")
    private WebElement instruction;

    public void login(String username, String password) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.passwordInput.clear();
        this.passwordInput.sendKeys(new CharSequence[]{password});
        UIUtils.clickLink(this.submitButton);
    }

    public void login(String password) {
        this.passwordInput.clear();
        this.passwordInput.sendKeys(new CharSequence[]{password});
        UIUtils.clickLink(this.submitButton);
    }

    public void missingPassword(String username) {
        this.usernameInput.clear();
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.passwordInput.clear();
        UIUtils.clickLink(this.submitButton);
    }

    public void missingUsername() {
        this.usernameInput.clear();
        UIUtils.clickLink(this.submitButton);
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public boolean isUsernameInputEnabled() {
        return this.usernameInput.isEnabled();
    }

    public String getPassword() {
        return this.passwordInput.getAttribute("value");
    }

    public void cancel() {
        this.cancelButton.click();
    }

    public String getInputError() {
        try {
            return UIUtils.getTextFromElement(this.inputError);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getError() {
        try {
            return UIUtils.getTextFromElement(this.loginErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getInstruction() {
        return this.instruction != null ? this.instruction.getText() : null;
    }

    public String getSuccessMessage() {
        return this.loginSuccessMessage != null ? this.loginSuccessMessage.getText() : null;
    }

    public String getInfoMessage() {
        return this.loginInfoMessage != null ? this.loginInfoMessage.getText() : null;
    }

    @Override
    public boolean isCurrent() {
        String realm = "test";
        return this.isCurrent(realm);
    }

    public boolean isCurrent(String realm) {
        return DroneUtils.getCurrentDriver().getTitle().equals("Sign in to " + realm) || DroneUtils.getCurrentDriver().getTitle().equals("Anmeldung bei " + realm);
    }

    public void assertCurrent(String realm) {
        String name = this.getClass().getSimpleName();
        Assert.assertTrue((String)("Expected " + name + " but was " + DroneUtils.getCurrentDriver().getTitle() + " (" + DroneUtils.getCurrentDriver().getCurrentUrl() + ")"), (boolean)this.isCurrent(realm));
    }

    public void clickRegister() {
        this.registerLink.click();
    }

    public void clickSocial(String alias) {
        WebElement socialButton = this.findSocialButton(alias);
        UIUtils.clickLink(socialButton);
    }

    public WebElement findSocialButton(String alias) {
        String id = "social-" + alias;
        return DroneUtils.getCurrentDriver().findElement(By.id((String)id));
    }

    public void resetPassword() {
        UIUtils.clickLink(this.resetPasswordLink);
    }

    public void recoverUsername() {
        UIUtils.clickLink(this.recoverUsernameLink);
    }

    public void setRememberMe(boolean enable) {
        boolean current = this.rememberMe.isSelected();
        if (current != enable) {
            this.rememberMe.click();
        }
    }

    public boolean isRememberMeChecked() {
        return this.rememberMe.isSelected();
    }

    @Override
    public void open() {
        this.oauth.openLoginForm();
        this.assertCurrent();
    }
}

