/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.keycloak.testsuite.pages.AbstractPage;
import org.keycloak.testsuite.util.UIUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginConfigTotpPage
extends AbstractPage {
    @FindBy(id="totpSecret")
    private WebElement totpSecret;
    @FindBy(id="totp")
    private WebElement totpInput;
    @FindBy(id="userLabel")
    private WebElement totpLabelInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;
    @FindBy(name="cancel-aia")
    private WebElement cancelAIAButton;
    @FindBy(id="mode-barcode")
    private WebElement barcodeLink;
    @FindBy(id="mode-manual")
    private WebElement manualLink;
    @FindBy(className="alert-error")
    private WebElement loginAlertErrorMessage;
    @FindBy(id="input-error-otp-code")
    private WebElement totpInputCodeError;
    @FindBy(id="input-error-otp-label")
    private WebElement totpInputLabelError;

    public void configure(String totp) {
        this.totpInput.sendKeys(new CharSequence[]{totp});
        this.submitButton.click();
    }

    public void configure(String totp, String userLabel) {
        this.totpInput.sendKeys(new CharSequence[]{totp});
        this.totpLabelInput.sendKeys(new CharSequence[]{userLabel});
        this.submitButton.click();
    }

    public void submit() {
        this.submitButton.click();
    }

    public void cancel() {
        this.cancelAIAButton.click();
    }

    public String getTotpSecret() {
        return this.totpSecret.getAttribute("value");
    }

    @Override
    public boolean isCurrent() {
        try {
            this.driver.findElement(By.id((String)"totp"));
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException();
    }

    public void clickManual() {
        this.manualLink.click();
    }

    public void clickBarcode() {
        this.barcodeLink.click();
    }

    public String getInputCodeError() {
        try {
            return UIUtils.getTextFromElement(this.totpInputCodeError);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getInputLabelError() {
        try {
            return UIUtils.getTextFromElement(this.totpInputLabelError);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getAlertError() {
        try {
            return UIUtils.getTextFromElement(this.loginAlertErrorMessage);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public boolean isCancelDisplayed() {
        try {
            return this.cancelAIAButton.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

