/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.pages;

import org.junit.Assert;
import org.keycloak.testsuite.pages.AbstractPage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public abstract class LanguageComboboxAwarePage
extends AbstractPage {
    @FindBy(id="kc-current-locale-link")
    private WebElement languageText;
    @FindBy(id="kc-locale-dropdown")
    private WebElement localeDropdown;
    @FindBy(id="try-another-way")
    private WebElement tryAnotherWayLink;
    @FindBy(id="kc-attempted-username")
    private WebElement attemptedUsernameLabel;
    @FindBy(id="reset-login")
    private WebElement resetLoginLink;

    public String getLanguageDropdownText() {
        return this.languageText.getText();
    }

    public void openLanguage(String language) {
        WebElement langLink = this.localeDropdown.findElement(By.xpath((String)("//a[text()='" + language + "']")));
        String url = langLink.getAttribute("href");
        DroneUtils.getCurrentDriver().navigate().to(url);
        WaitUtils.waitForPageToLoad();
    }

    public void assertTryAnotherWayLinkAvailability(boolean expectedAvailability) {
        try {
            this.driver.findElement(By.id((String)"try-another-way"));
            Assert.assertTrue((boolean)expectedAvailability);
        }
        catch (NoSuchElementException nse) {
            Assert.assertFalse((boolean)expectedAvailability);
        }
    }

    public void clickTryAnotherWayLink() {
        this.tryAnotherWayLink.click();
    }

    public void assertAttemptedUsernameAvailability(boolean expectedAvailability) {
        LanguageComboboxAwarePage.assertAttemptedUsernameAvailability(this.driver, expectedAvailability);
    }

    public static void assertAttemptedUsernameAvailability(WebDriver driver, boolean expectedAvailability) {
        try {
            driver.findElement(By.id((String)"kc-attempted-username"));
            Assert.assertTrue((boolean)expectedAvailability);
        }
        catch (NoSuchElementException nse) {
            Assert.assertFalse((boolean)expectedAvailability);
        }
    }

    public String getAttemptedUsername() {
        return this.attemptedUsernameLabel.getText();
    }

    public void clickResetLogin() {
        this.resetLoginLink.click();
    }
}

